/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp.preferences;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class PreferencePages {
    public static final String PREFERENCE_PAGE_EXTENTIONPOINT_ID = "org.eclipse.ui.preferencePages";

    public static String createLinkLabelToPreferencePage(String preferencePageID) {
        String text = PreferencePages.getNameOfPreferencePage(preferencePageID);
        String categoryID = PreferencePages.getCategoryOfPreferencePage(preferencePageID);
        while (categoryID != null) {
            text = String.valueOf(PreferencePages.getNameOfPreferencePage(categoryID)) + " > " + text;
            categoryID = PreferencePages.getCategoryOfPreferencePage(categoryID);
        }
        if (text == null) {
            return "";
        }
        return text;
    }

    private static String getNameOfPreferencePage(String preferencePageID) {
        return PreferencePages.getAttributeOfPreferencePage(preferencePageID, "name");
    }

    private static String getCategoryOfPreferencePage(String preferencePageID) {
        return PreferencePages.getAttributeOfPreferencePage(preferencePageID, "category");
    }

    private static String getAttributeOfPreferencePage(String preferencePageID, String attribute) {
        IConfigurationElement[] elements;
        if (preferencePageID != null && (elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PREFERENCE_PAGE_EXTENTIONPOINT_ID)) != null) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String configId = e.getAttribute("id");
                if (preferencePageID.equalsIgnoreCase(configId)) {
                    return e.getAttribute(attribute);
                }
                ++n2;
            }
        }
        return null;
    }
}

