/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.util.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisResponseBase
extends SolrResponseBase {
    protected List<AnalysisPhase> buildPhases(NamedList<Object> phaseNL) {
        ArrayList<AnalysisPhase> phases = new ArrayList<AnalysisPhase>(phaseNL.size());
        for (Map.Entry<String, Object> entry : phaseNL) {
            AnalysisPhase phase = new AnalysisPhase(entry.getKey());
            List tokens = (List)entry.getValue();
            for (NamedList token : tokens) {
                TokenInfo tokenInfo = this.buildTokenInfo(token);
                phase.addTokenInfo(tokenInfo);
            }
            phases.add(phase);
        }
        return phases;
    }

    protected TokenInfo buildTokenInfo(NamedList tokenNL) {
        String text = (String)tokenNL.get("text");
        String rawText = (String)tokenNL.get("rawText");
        String type = (String)tokenNL.get("type");
        int start = (Integer)tokenNL.get("start");
        int end = (Integer)tokenNL.get("end");
        int position = (Integer)tokenNL.get("position");
        Boolean match = (Boolean)tokenNL.get("match");
        return new TokenInfo(text, rawText, type, start, end, position, match == null ? false : match);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnalysisPhase {
        private final String className;
        private List<TokenInfo> tokens = new ArrayList<TokenInfo>();

        AnalysisPhase(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        private void addTokenInfo(TokenInfo tokenInfo) {
            this.tokens.add(tokenInfo);
        }

        public List<TokenInfo> getTokens() {
            return this.tokens;
        }
    }

    public static class TokenInfo {
        private final String text;
        private final String rawText;
        private final String type;
        private final int start;
        private final int end;
        private final int position;
        private final boolean match;

        TokenInfo(String text, String rawText, String type, int start, int end, int position, boolean match) {
            this.text = text;
            this.rawText = rawText;
            this.type = type;
            this.start = start;
            this.end = end;
            this.position = position;
            this.match = match;
        }

        public String getText() {
            return this.text;
        }

        public String getRawText() {
            return this.rawText;
        }

        public String getType() {
            return this.type;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isMatch() {
            return this.match;
        }
    }
}

