/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.types.rcp;

import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.recommenders.internal.types.rcp.IIndexProvider;
import org.eclipse.recommenders.internal.types.rcp.IProjectTypesIndex;
import org.eclipse.recommenders.internal.types.rcp.ITypesIndexService;
import org.eclipse.recommenders.internal.types.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class TypesIndexService
implements ITypesIndexService,
IElementChangedListener {
    private final IIndexProvider indexProvider;

    @Inject
    public TypesIndexService(IIndexProvider indexProvider) {
        this.indexProvider = indexProvider;
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)new ShutdownListener());
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        this.process(delta);
    }

    private void process(IJavaElementDelta delta) {
        boolean resolvedClasspathChanged;
        IJavaElement element = delta.getElement();
        IJavaProject project = element.getJavaProject();
        boolean bl = resolvedClasspathChanged = (delta.getFlags() & 0x200000) != 0;
        if (element instanceof IJavaProject && resolvedClasspathChanged) {
            this.rebuildIndex(element.getJavaProject());
            return;
        }
        if (this.isChildAffectedByChange(delta)) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                this.process(child);
                ++n2;
            }
            return;
        }
        switch (delta.getKind()) {
            case 1: {
                this.processElementAdded(element, project);
                break;
            }
            case 4: {
                this.processElementChanged(delta, element, project);
                break;
            }
            case 2: {
                this.processElementRemoved(element, project);
            }
        }
    }

    private boolean isChildAffectedByChange(IJavaElementDelta delta) {
        return (delta.getFlags() & 8) != 0;
    }

    private void processElementAdded(IJavaElement element, IJavaProject project) {
        switch (element.getElementType()) {
            case 2: 
            case 3: {
                this.rebuildIndex(project);
            }
        }
    }

    private void processElementChanged(IJavaElementDelta delta, IJavaElement element, IJavaProject project) {
        if (3 == element.getElementType()) {
            boolean content;
            boolean removed = (delta.getFlags() & 0x80) != 0;
            boolean bl = content = (delta.getFlags() & 0x8000) != 0;
            if (removed || content) {
                this.rebuildIndex(project);
            }
        }
    }

    private void processElementRemoved(IJavaElement element, IJavaProject project) {
        switch (element.getElementType()) {
            case 3: {
                this.rebuildIndex(project);
                break;
            }
            case 2: {
                this.removeProjectIndex(project);
            }
        }
    }

    private void rebuildIndex(IJavaProject project) {
        IProjectTypesIndex index = (IProjectTypesIndex)this.indexProvider.findIndex(project).orNull();
        if (index == null) {
            return;
        }
        index.suggestRebuild();
    }

    private void removeProjectIndex(IJavaProject project) {
        this.indexProvider.deleteIndex(project);
    }

    @Override
    public Set<String> subtypes(ITypeName expected, IJavaProject project) {
        IProjectTypesIndex index = this.indexProvider.findOrCreateIndex(project);
        return index.subtypes(expected);
    }

    private final class ShutdownListener
    implements IWorkbenchListener {
        private ShutdownListener() {
        }

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
            try {
                TypesIndexService.this.indexProvider.close();
            }
            catch (IOException e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_CLOSING_PROJECT_TYPES_INDEXES, (Throwable)e);
            }
        }
    }
}

