/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.handles;

import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.ILocator;
import org.eclipse.wb.draw2d.events.IAncestorListener;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;

public abstract class Handle
extends Figure
implements IAncestorListener {
    private final GraphicalEditPart m_owner;
    private final ILocator m_locator;
    private Tool m_dragTracker;

    public Handle(GraphicalEditPart owner, ILocator locator) {
        this.m_owner = owner;
        this.m_locator = locator;
    }

    protected void addNotify() {
        super.addNotify();
        this.getOwnerFigure().addAncestorListener(this);
        this.revalidate();
    }

    protected void removeNotify() {
        this.getOwnerFigure().removeAncestorListener(this);
        super.removeNotify();
    }

    public void ancestorMoved(Figure ancestor) {
        this.revalidate();
    }

    private void revalidate() {
        this.getLocator().relocate(this);
    }

    protected final GraphicalEditPart getOwner() {
        return this.m_owner;
    }

    protected final Figure getOwnerFigure() {
        return this.getOwner().getFigure();
    }

    protected final ILocator getLocator() {
        return this.m_locator;
    }

    public Tool getDragTrackerTool() {
        if (this.m_dragTracker == null) {
            this.m_dragTracker = this.createDragTrackerTool();
        }
        return this.m_dragTracker;
    }

    public void setDragTrackerTool(Tool dragTracker) {
        this.m_dragTracker = dragTracker;
    }

    protected final Tool createDragTrackerTool() {
        return null;
    }
}

