/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.core.gef.GefMessages;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.IActionImageProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementsSupport;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;

public class AnchorsActionsSupport {
    private final PlacementsSupport m_placementsSupport;
    private final IActionImageProvider m_imageProvider;

    public AnchorsActionsSupport(PlacementsSupport placementsSupport, IActionImageProvider imageProvider) {
        this.m_placementsSupport = placementsSupport;
        this.m_imageProvider = imageProvider;
    }

    public void fillAnchorsActions(IContributionManager manager, IAbstractComponentInfo widget, boolean isHorizontal) {
        if (isHorizontal) {
            manager.add((IAction)new SetAlignmentAction(widget, GefMessages.AnchorsActionsSupport_leftAlignment, "h/menu/left.gif", 1));
            manager.add((IAction)new SetAlignmentAction(widget, GefMessages.AnchorsActionsSupport_rightAlignment, "h/menu/right.gif", 4));
            manager.add((IAction)new MakeResizeableAction(widget, GefMessages.AnchorsActionsSupport_makeResizableHorizontal, "h/menu/both.gif", isHorizontal));
        } else {
            manager.add((IAction)new SetAlignmentAction(widget, GefMessages.AnchorsActionsSupport_topAlignment, "v/menu/top.gif", 8));
            manager.add((IAction)new SetAlignmentAction(widget, GefMessages.AnchorsActionsSupport_bottomAlignment, "v/menu/bottom.gif", 32));
            manager.add((IAction)new MakeResizeableAction(widget, GefMessages.AnchorsActionsSupport_makeResizableVertical, "v/menu/both.gif", isHorizontal));
        }
    }

    private final class MakeResizeableAction
    extends ObjectInfoAction {
        private final boolean m_isHorizontal;
        private final IAbstractComponentInfo m_widget;

        private MakeResizeableAction(IAbstractComponentInfo widget, String text, String imageName, boolean isHorizontal) {
            super(widget.getUnderlyingModel(), text, AnchorsActionsSupport.this.m_imageProvider.getActionImage(imageName));
            this.m_widget = widget;
            this.m_isHorizontal = isHorizontal;
        }

        protected void runEx() throws Exception {
            AnchorsActionsSupport.this.m_placementsSupport.setResizeable(this.m_widget, this.m_isHorizontal);
        }
    }

    private final class SetAlignmentAction
    extends ObjectInfoAction {
        private final int m_alignment;
        private final IAbstractComponentInfo m_widget;

        private SetAlignmentAction(IAbstractComponentInfo widget, String text, String imageName, int alignment) {
            super(widget.getUnderlyingModel(), text, AnchorsActionsSupport.this.m_imageProvider.getActionImage(imageName));
            this.m_widget = widget;
            this.m_alignment = alignment;
        }

        protected void runEx() throws Exception {
            AnchorsActionsSupport.this.m_placementsSupport.setAlignment(this.m_widget, this.m_alignment);
        }
    }
}

