/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class XmlWriter {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final int TAG_STATE_BEGIN_NOT_ENDED = 1;
    private static final int TAG_STATE_OPEN = 2;
    private static final int TAG_STATE_HAS_CHILDRED = 4;
    private static final int TAG_STATE_HAS_VALUE = 8;
    private static final int TAG_STATE_CDATA_OPEN = 16;
    private final PrintWriter m_printWriter;
    private String m_indent = "\t";
    private final Stack<TagInfo> m_tagStack = new Stack();
    private boolean m_closed;
    private boolean m_isShortTagClosed;

    public XmlWriter(File file) throws Exception {
        this(new PrintWriter(file, "UTF-8"));
    }

    public XmlWriter(String filePath) throws Exception {
        this(new PrintWriter(filePath, "UTF-8"));
    }

    public XmlWriter(Writer writer) {
        this.m_printWriter = new PrintWriter(writer);
        this.m_printWriter.print(XML_HEADER);
    }

    public void beginTag(String tagName) {
        this.checkOpen();
        Assert.isLegal(!StringUtils.isEmpty((String)tagName), "Can't add tag with empty name.");
        if (!this.m_tagStack.empty()) {
            TagInfo currentTag = this.m_tagStack.peek();
            if (this.isState(currentTag, 1)) {
                throw new IllegalStateException("Another tag already began for attribute adding.");
            }
            this.addState(currentTag, 4);
        }
        this.m_tagStack.push(new TagInfo(tagName, 1));
        if (!this.m_isShortTagClosed) {
            this.m_printWriter.println();
        }
        this.m_isShortTagClosed = false;
        this.m_printWriter.print(StringUtils.repeat((String)this.getIndent(), (int)(this.m_tagStack.size() - 1)));
        this.m_printWriter.print("<" + tagName);
    }

    public void endTag() {
        this.checkOpen();
        TagInfo currentTag = this.peek();
        if (this.isState(currentTag, 1)) {
            this.m_printWriter.print(">");
            currentTag.setState(2);
        }
    }

    public void writeAttribute(String attrName, String attrValue) {
        this.checkOpen();
        Assert.isLegal(!StringUtils.isEmpty((String)attrName), "Can't add attribute with empty name.");
        TagInfo currentTag = this.peek();
        if (!this.isState(currentTag, 1)) {
            throw new IllegalStateException("Tag should be open for attribute adding.");
        }
        if (attrValue == null) {
            attrValue = "";
        }
        attrValue = StringEscapeUtils.escapeXml((String)attrValue);
        StringBuilder escaped = new StringBuilder();
        int i = 0;
        while (i < attrValue.length()) {
            char c = attrValue.charAt(i);
            if (c < ' ') {
                escaped.append("&#");
                escaped.append((int)c);
                escaped.append(";");
            } else {
                escaped.append(c);
            }
            ++i;
        }
        attrValue = escaped.toString();
        this.m_printWriter.print(" " + attrName + "=\"" + (attrValue == null ? "" : attrValue) + "\"");
    }

    public void openTag(String tagName) {
        this.beginTag(tagName);
        this.endTag();
    }

    public void closeTag() {
        this.checkOpen();
        TagInfo currentTag = this.peek();
        boolean validState = false;
        if (this.isState(currentTag, 1)) {
            this.m_printWriter.println("/>");
            this.m_isShortTagClosed = true;
            validState = true;
        } else if (this.hasState(currentTag, 2)) {
            if (this.hasState(currentTag, 4)) {
                if (this.hasState(currentTag, 8)) {
                    this.m_printWriter.println();
                }
                this.m_printWriter.print(StringUtils.repeat((String)this.getIndent(), (int)(this.m_tagStack.size() - 1)));
            }
            this.m_printWriter.println("</" + currentTag.getName() + ">");
            validState = true;
        } else if (this.hasState(currentTag, 16)) {
            this.m_printWriter.println("</" + currentTag.getName() + ">");
            validState = true;
        }
        if (!validState) {
            this.close();
            throw new IllegalStateException("Can't do close operation when currently no open tag.");
        }
        this.m_tagStack.pop();
    }

    public void write(String tagValue) {
        this.checkOpen();
        TagInfo currentTag = this.peek();
        if (this.hasState(currentTag, 2)) {
            if (this.hasState(currentTag, 8)) {
                throw new IllegalStateException("Current tag already have the value written.");
            }
        } else {
            throw new IllegalStateException("Can't write tag value when currently no tag open for writing tag value.");
        }
        String valueToWrite = tagValue != null ? tagValue : "";
        this.m_printWriter.print(StringEscapeUtils.escapeXml((String)valueToWrite));
        this.addState(currentTag, 8);
    }

    public void write(String tagName, String tagValue) {
        this.openTag(tagName);
        this.write(tagValue);
        this.closeTag();
    }

    public OutputStream streamCDATA() {
        this.checkOpen();
        final TagInfo currentTag = this.peek();
        if (this.hasState(currentTag, 2)) {
            if (this.hasState(currentTag, 8)) {
                throw new IllegalStateException("Current tag already have the value written.");
            }
            this.m_printWriter.println("<![CDATA[");
            this.addState(currentTag, 16);
            return new OutputStream(){

                public void write(int b) throws IOException {
                    XmlWriter.this.m_printWriter.print((char)b);
                }

                public void close() throws IOException {
                    XmlWriter.this.m_printWriter.print("]]>");
                    XmlWriter.this.removeState(currentTag, 16);
                    XmlWriter.this.addState(currentTag, 8);
                }
            };
        }
        throw new IllegalStateException("No open tag to write CDATA contents.");
    }

    public void close() {
        this.m_printWriter.close();
        this.m_closed = true;
    }

    private void checkOpen() {
        if (this.m_closed) {
            throw new IllegalStateException("XMLWriter is closed.");
        }
    }

    private TagInfo peek() {
        Assert.isTrue(!this.m_tagStack.empty(), "No any open tag.");
        return this.m_tagStack.peek();
    }

    private boolean hasState(TagInfo tag, int stateMask) {
        return (tag.getState() & stateMask) != 0;
    }

    private void addState(TagInfo tag, int stateMask) {
        tag.setState(tag.getState() | stateMask);
    }

    private void removeState(TagInfo tag, int stateMask) {
        tag.setState(tag.getState() & ~stateMask);
    }

    private boolean isState(TagInfo tag, int stateMask) {
        return tag.getState() == stateMask;
    }

    public final String getIndent() {
        return this.m_indent;
    }

    public final void setIndent(String indent) {
        this.m_indent = indent;
    }

    private static final class TagInfo {
        private final String m_name;
        private int m_state;

        public TagInfo(String tagName, int state) {
            this.m_name = tagName;
            this.m_state = state;
        }

        public final int getState() {
            return this.m_state;
        }

        public final void setState(int tagState) {
            this.m_state = tagState;
        }

        public final String getName() {
            return this.m_name;
        }
    }
}

