/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wb.internal.core.utils.reflect.ClassLoaderLocalMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassMap<V> {
    public static <V> ClassMap<V> create() {
        return new ClassMap<V>();
    }

    public void put(Class<?> key, V value) {
        this.getMap(key).put(key, value);
    }

    public V get(Class<?> key) {
        return this.getMap(key).get(key);
    }

    public void remove(Class<?> key) {
        this.getMap(key).remove(key);
    }

    public void clear(ClassLoader classLoader) {
        this.getMap(classLoader).clear();
    }

    private Map<Class<?>, V> getMap(Class<?> key) {
        ClassLoader classLoader = key.getClassLoader();
        return this.getMap(classLoader);
    }

    private Map<Class<?>, V> getMap(ClassLoader classLoader) {
        HashMap map = ClassLoaderLocalMap.get(classLoader, this);
        if (map == null) {
            map = new HashMap();
            ClassLoaderLocalMap.put(classLoader, this, map);
        }
        return map;
    }
}

