/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.tree;

import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.draw2d.EventManager;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.tree.dnd.TreeDropListener;
import org.eclipse.wb.internal.gef.tree.dnd.TreeTransfer;
import org.eclipse.wb.os.OSSupport;

final class TreeEventManager
implements KeyListener,
MouseListener,
MouseMoveListener,
MouseTrackListener {
    private final Tree m_tree;
    private final IEditPartViewer m_viewer;
    private EditDomain m_domain;
    final TreeDropListener m_dropListener;

    public TreeEventManager(Tree tree, IEditPartViewer viewer) {
        this.m_tree = tree;
        this.m_viewer = viewer;
        Object listener = EventManager.createListenerProxy(this, new Class[]{KeyListener.class, MouseListener.class, MouseMoveListener.class, MouseTrackListener.class});
        this.m_tree.addKeyListener((KeyListener)listener);
        this.m_tree.addMouseListener((MouseListener)listener);
        this.m_tree.addMouseMoveListener((MouseMoveListener)listener);
        this.m_tree.addMouseTrackListener((MouseTrackListener)listener);
        new DragSource((Control)this.m_tree, 2).setTransfer(new Transfer[]{TreeTransfer.INSTANCE});
        this.m_dropListener = new TreeDropListener(this.m_viewer);
    }

    public void setDomain(EditDomain domain) {
        this.m_domain = domain;
    }

    public void keyPressed(KeyEvent event) {
        if (this.m_domain != null) {
            this.m_domain.keyPressed(event, this.m_viewer);
        }
    }

    public void keyReleased(KeyEvent event) {
        if (this.m_domain != null) {
            this.m_domain.keyReleased(event, this.m_viewer);
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        if (this.m_domain != null) {
            this.m_domain.mouseDoubleClick(event, this.m_viewer);
        }
    }

    public void mouseDown(MouseEvent event) {
        if (TreeEventManager.isPlusMinusClick(this.m_tree, event.x, event.y)) {
            return;
        }
        if (this.m_domain != null) {
            this.m_domain.mouseDown(event, this.m_viewer);
        }
    }

    public void mouseUp(MouseEvent event) {
        if (this.m_domain != null) {
            this.m_domain.mouseUp(event, this.m_viewer);
        }
    }

    public void mouseMove(MouseEvent event) {
        if (this.m_domain != null) {
            if ((event.stateMask & 0x380000) != 0) {
                this.m_domain.mouseDrag(event, this.m_viewer);
            } else {
                this.m_domain.mouseMove(event, this.m_viewer);
            }
        }
    }

    public void mouseEnter(MouseEvent event) {
        if (this.m_domain != null) {
            this.m_domain.viewerEntered(event, this.m_viewer);
        }
    }

    public void mouseExit(MouseEvent event) {
        if (this.m_domain != null) {
            this.m_domain.viewerExited(event, this.m_viewer);
        }
    }

    public void mouseHover(MouseEvent event) {
    }

    private static boolean isPlusMinusClick(Tree tree, int x, int y) {
        return OSSupport.get().isPlusMinusTreeClick(tree, x, y);
    }
}

