/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaConversionValue
extends AbstractJavaContextModel<EclipseLinkJavaObjectTypeConverter>
implements EclipseLinkConversionValue {
    private final ConversionValueAnnotation conversionValueAnnotation;
    private String dataValue;
    private String objectValue;

    public EclipseLinkJavaConversionValue(EclipseLinkJavaObjectTypeConverter parent, ConversionValueAnnotation conversionValueAnnotation) {
        super((JpaContextModel)parent);
        this.conversionValueAnnotation = conversionValueAnnotation;
        this.dataValue = conversionValueAnnotation.getDataValue();
        this.objectValue = conversionValueAnnotation.getObjectValue();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDataValue_(this.conversionValueAnnotation.getDataValue());
        this.setObjectValue_(this.conversionValueAnnotation.getObjectValue());
    }

    @Override
    public String getDataValue() {
        return this.dataValue;
    }

    @Override
    public void setDataValue(String value) {
        this.conversionValueAnnotation.setDataValue(value);
        this.setDataValue_(value);
    }

    protected void setDataValue_(String value) {
        String old = this.dataValue;
        this.dataValue = value;
        this.firePropertyChanged("dataValue", old, value);
    }

    @Override
    public String getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(String value) {
        this.conversionValueAnnotation.setObjectValue(value);
        this.setObjectValue_(value);
    }

    protected void setObjectValue_(String value) {
        String old = this.objectValue;
        this.objectValue = value;
        this.firePropertyChanged("objectValue", old, value);
    }

    protected EclipseLinkJavaObjectTypeConverter getObjectTypeConverter() {
        return (EclipseLinkJavaObjectTypeConverter)this.parent;
    }

    public ConversionValueAnnotation getConversionValueAnnotation() {
        return this.conversionValueAnnotation;
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
    }

    public TextRange getDataValueTextRange() {
        return this.getValidationTextRange(this.conversionValueAnnotation.getDataValueTextRange());
    }

    protected TextRange getObjectValueTextRange() {
        return this.getValidationTextRange(this.conversionValueAnnotation.getObjectValueTextRange());
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.conversionValueAnnotation.getTextRange();
        return textRange != null ? textRange : this.getObjectTypeConverter().getValidationTextRange();
    }

    @Override
    public boolean isEquivalentTo(EclipseLinkConversionValue conversionValue) {
        return ObjectTools.equals((Object)this.dataValue, (Object)conversionValue.getDataValue()) && ObjectTools.equals((Object)this.objectValue, (Object)conversionValue.getObjectValue());
    }
}

