/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence;

import java.util.Map;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkDdlGenerationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkOutputMode;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkSchemaGenerationImpl
extends EclipseLinkPersistenceUnitProperties
implements EclipseLinkSchemaGeneration {
    private EclipseLinkOutputMode outputMode;
    private EclipseLinkDdlGenerationType ddlGenerationType;
    private String createFileName;
    private String dropFileName;
    private String applicationLocation;

    public EclipseLinkSchemaGenerationImpl(PersistenceUnit parent) {
        super(parent);
    }

    protected void initializeProperties() {
        this.outputMode = (EclipseLinkOutputMode)this.getEnumValue("eclipselink.ddl-generation.output-mode", EclipseLinkOutputMode.values());
        this.ddlGenerationType = (EclipseLinkDdlGenerationType)this.getEnumValue("eclipselink.ddl-generation", EclipseLinkDdlGenerationType.values());
        this.createFileName = this.getStringValue("eclipselink.create-ddl-jdbc-file-name");
        this.dropFileName = this.getStringValue("eclipselink.drop-ddl-jdbc-file-name");
        this.applicationLocation = this.getStringValue("eclipselink.application-location");
    }

    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.ddl-generation.output-mode", "outputMode");
        propertyNames.put("eclipselink.ddl-generation", "ddlGenerationType");
        propertyNames.put("eclipselink.create-ddl-jdbc-file-name", "createFileName");
        propertyNames.put("eclipselink.drop-ddl-jdbc-file-name", "dropFileName");
        propertyNames.put("eclipselink.application-location", "applicationLocation");
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.ddl-generation.output-mode")) {
            this.outputModeChanged(newValue);
        } else if (propertyName.equals("eclipselink.ddl-generation")) {
            this.ddlGenerationTypeChanged(newValue);
        } else if (propertyName.equals("eclipselink.create-ddl-jdbc-file-name")) {
            this.createFileNameChanged(newValue);
        } else if (propertyName.equals("eclipselink.drop-ddl-jdbc-file-name")) {
            this.dropFileNameChanged(newValue);
        } else if (propertyName.equals("eclipselink.application-location")) {
            this.applicationLocationChanged(newValue);
        }
    }

    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.ddl-generation.output-mode")) {
            this.outputModeChanged(null);
        } else if (propertyName.equals("eclipselink.ddl-generation")) {
            this.ddlGenerationTypeChanged(null);
        } else if (propertyName.equals("eclipselink.create-ddl-jdbc-file-name")) {
            this.createFileNameChanged(null);
        } else if (propertyName.equals("eclipselink.drop-ddl-jdbc-file-name")) {
            this.dropFileNameChanged(null);
        } else if (propertyName.equals("eclipselink.application-location")) {
            this.applicationLocationChanged(null);
        }
    }

    @Override
    public EclipseLinkDdlGenerationType getDdlGenerationType() {
        return this.ddlGenerationType;
    }

    @Override
    public void setDdlGenerationType(EclipseLinkDdlGenerationType newDdlGenType) {
        EclipseLinkDdlGenerationType old = this.ddlGenerationType;
        this.ddlGenerationType = newDdlGenType;
        this.putProperty("ddlGenerationType", newDdlGenType);
        this.firePropertyChanged("ddlGenerationType", (Object)old, (Object)newDdlGenType);
    }

    private void ddlGenerationTypeChanged(String stringValue) {
        EclipseLinkDdlGenerationType newValue = (EclipseLinkDdlGenerationType)this.getEnumValueOf(stringValue, EclipseLinkDdlGenerationType.values());
        EclipseLinkDdlGenerationType old = this.ddlGenerationType;
        this.ddlGenerationType = newValue;
        this.firePropertyChanged("ddlGenerationType", (Object)old, (Object)newValue);
    }

    @Override
    public EclipseLinkDdlGenerationType getDefaultDdlGenerationType() {
        return DEFAULT_SCHEMA_GENERATION_DDL_GENERATION_TYPE;
    }

    @Override
    public EclipseLinkOutputMode getOutputMode() {
        return this.outputMode;
    }

    @Override
    public void setOutputMode(EclipseLinkOutputMode newOutputMode) {
        EclipseLinkOutputMode old = this.outputMode;
        this.outputMode = newOutputMode;
        this.putProperty("outputMode", newOutputMode);
        this.firePropertyChanged("outputMode", (Object)old, (Object)newOutputMode);
    }

    private void outputModeChanged(String stringValue) {
        EclipseLinkOutputMode newValue = (EclipseLinkOutputMode)this.getEnumValueOf(stringValue, EclipseLinkOutputMode.values());
        EclipseLinkOutputMode old = this.outputMode;
        this.outputMode = newValue;
        this.firePropertyChanged("outputMode", (Object)old, (Object)newValue);
    }

    @Override
    public EclipseLinkOutputMode getDefaultOutputMode() {
        return DEFAULT_SCHEMA_GENERATION_OUTPUT_MODE;
    }

    @Override
    public String getCreateFileName() {
        return this.createFileName;
    }

    @Override
    public void setCreateFileName(String newCreateFileName) {
        String old = this.createFileName;
        this.createFileName = newCreateFileName;
        this.putProperty("createFileName", newCreateFileName);
        this.firePropertyChanged("createFileName", old, newCreateFileName);
    }

    private void createFileNameChanged(String newValue) {
        String old = this.createFileName;
        this.createFileName = newValue;
        this.firePropertyChanged("createFileName", old, newValue);
    }

    @Override
    public String getDefaultCreateFileName() {
        return "createDDL.sql";
    }

    @Override
    public String getDropFileName() {
        return this.dropFileName;
    }

    @Override
    public void setDropFileName(String newDropFileName) {
        String old = this.dropFileName;
        this.dropFileName = newDropFileName;
        this.putProperty("dropFileName", newDropFileName);
        this.firePropertyChanged("dropFileName", old, newDropFileName);
    }

    private void dropFileNameChanged(String newValue) {
        String old = this.dropFileName;
        this.dropFileName = newValue;
        this.firePropertyChanged("dropFileName", old, newValue);
    }

    @Override
    public String getDefaultDropFileName() {
        return "dropDDL.sql";
    }

    @Override
    public String getApplicationLocation() {
        return this.applicationLocation;
    }

    @Override
    public void setApplicationLocation(String newApplicationLocation) {
        String old = this.applicationLocation;
        this.applicationLocation = StringTools.isNotBlank((String)newApplicationLocation) ? newApplicationLocation : this.getDefaultApplicationLocation();
        this.putProperty("applicationLocation", this.applicationLocation);
        this.firePropertyChanged("applicationLocation", old, this.applicationLocation);
    }

    private void applicationLocationChanged(String newValue) {
        String old = this.applicationLocation;
        this.applicationLocation = newValue;
        this.firePropertyChanged("applicationLocation", old, newValue);
    }

    @Override
    public String getDefaultApplicationLocation() {
        return DEFAULT_SCHEMA_GENERATION_APPLICATION_LOCATION;
    }
}

