/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.gen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.gen.JptGenerator;
import org.eclipse.jpt.common.core.gen.LaunchConfigListener;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJptGenerator
implements JptGenerator {
    public static final String PLUGINS_DIR = "plugins/";
    private IVMInstall jre;
    private ILaunchConfigurationWorkingCopy launchConfig;
    ILaunch launch;
    private final IJavaProject javaProject;
    private final String projectLocation;
    private final ListenerList<LaunchConfigListener> launchConfigListenerList;
    private boolean isDebug = false;

    protected AbstractJptGenerator(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.projectLocation = javaProject.getProject().getLocation().toString();
        this.launchConfigListenerList = this.buildLaunchConfigListenerList();
        this.initialize();
    }

    protected abstract String getMainType();

    protected abstract String getLaunchConfigName();

    protected String getBootstrapJarPrefix() {
        throw new RuntimeException("Bootstrap JAR not specified.");
    }

    protected abstract void specifyProgramArguments();

    protected abstract List<String> buildClasspath() throws CoreException;

    protected void initialize() {
        try {
            this.launchConfig = this.buildLaunchConfiguration();
            this.jre = this.getProjectJRE();
            if (this.jre == null) {
                String message = "Could not identify the VM.";
                throw new RuntimeException(message);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JptGenerator generate(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        this.preGenerate((IProgressMonitor)sm.newChild(2));
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        sm.subTask(JptCommonCoreMessages.GENERATION_CREATING_LAUNCH_CONFIG_TASK);
        this.initializeLaunchConfiguration();
        sm.worked(1);
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.addLaunchListener();
        sm.worked(1);
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.launch = this.saveAndLaunchConfig((IProgressMonitor)sm.newChild(6));
        return this;
    }

    private void initializeLaunchConfiguration() {
        this.specifyJRE();
        this.specifyProject();
        this.specifyMainType();
        this.specifyProgramArguments();
        this.specifyWorkingDir();
        this.specifyClasspathProperties();
    }

    private void addLaunchListener() {
        this.getLaunchManager().addLaunchListener((ILaunchesListener)this.buildLaunchListener());
    }

    void removeLaunchListener(ILaunchesListener2 listener) {
        this.getLaunchManager().removeLaunchListener((ILaunchesListener)listener);
    }

    protected abstract void preGenerate(IProgressMonitor var1);

    protected void postGenerate(boolean generationSuccessful) {
        try {
            if (!this.isDebug) {
                this.removeLaunchConfiguration();
            }
            this.notifyLaunchConfigListeners(generationSuccessful);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void notifyLaunchConfigListeners(boolean generationSuccessful) {
        for (LaunchConfigListener launchConfigListener : this.launchConfigListenerList) {
            launchConfigListener.launchCompleted(generationSuccessful);
        }
    }

    void generationSuccessful() {
        this.postGenerate(true);
    }

    void generationFailed() {
        this.postGenerate(false);
    }

    private ILaunchesListener2 buildLaunchListener() {
        return new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch terminatedLaunch = iLaunchArray[n2];
                    if (terminatedLaunch.equals(AbstractJptGenerator.this.getLaunch())) {
                        try {
                            if (terminatedLaunch.isTerminated()) {
                                if (this.generationIsSuccessful(terminatedLaunch.getProcesses())) {
                                    AbstractJptGenerator.this.generationSuccessful();
                                } else {
                                    AbstractJptGenerator.this.generationFailed();
                                }
                                AbstractJptGenerator.this.launch = null;
                            }
                        }
                        finally {
                            AbstractJptGenerator.this.removeLaunchListener(this);
                        }
                        return;
                    }
                    ++n2;
                }
            }

            private boolean generationIsSuccessful(IProcess[] processes) {
                int exitValue = -1;
                IProcess[] iProcessArray = processes;
                if (processes.length != 0) {
                    IProcess process = iProcessArray[0];
                    try {
                        exitValue = process.getExitValue();
                    }
                    catch (DebugException e) {
                        throw new RuntimeException(e);
                    }
                }
                return exitValue == 0;
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesRemoved(ILaunch[] launches) {
            }
        };
    }

    protected void specifyJRE() {
        String jreName = this.jre.getName();
        String vmId = this.jre.getVMInstallType().getId();
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, jreName);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmId);
    }

    private void specifyProject() {
        String projectName = this.getProject().getName();
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
    }

    protected IProject getProject() {
        return this.javaProject.getProject();
    }

    private void specifyMainType() {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.getMainType());
    }

    protected void specifyClasspathProperties() {
        List<String> classpath;
        try {
            classpath = this.buildClasspath();
        }
        catch (CoreException e) {
            throw new RuntimeException("An error occured generating a memento", e);
        }
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    protected IRuntimeClasspathEntry getSystemLibraryClasspathEntry() throws CoreException {
        Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
        return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1);
    }

    protected IRuntimeClasspathEntry getDefaultProjectClasspathEntry() {
        IRuntimeClasspathEntry projectEntry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)this.javaProject);
        projectEntry.setClasspathProperty(3);
        return projectEntry;
    }

    protected static IRuntimeClasspathEntry getArchiveClasspathEntry(IPath archivePath) {
        IRuntimeClasspathEntry archiveEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)archivePath);
        archiveEntry.setClasspathProperty(3);
        return archiveEntry;
    }

    protected static IRuntimeClasspathEntry getVariableRuntimeClasspathEntry(IPath path) {
        IRuntimeClasspathEntry varEntry = JavaRuntime.newVariableRuntimeClasspathEntry((IPath)path);
        varEntry.setClasspathProperty(3);
        return varEntry;
    }

    protected ILaunch saveAndLaunchConfig(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ILaunchConfiguration configuration = null;
        ILaunch result = null;
        try {
            sm.subTask(JptCommonCoreMessages.GENERATION_SAVING_LAUNCH_CONFIG_TASK);
            this.launchConfig.setAttribute("org.eclipse.debug.core.capture_output", true);
            configuration = this.launchConfig.doSave();
        }
        catch (CoreException saveException) {
            throw new RuntimeException("Could not save LaunchConfig", saveException);
        }
        sm.worked(1);
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            sm.subTask(JptCommonCoreMessages.GENERATION_LAUNCHING_CONFIG_TASK);
            result = configuration.launch("run", (IProgressMonitor)sm.newChild(9));
        }
        catch (CoreException launchException) {
            throw new RuntimeException("An error occured during launch", launchException);
        }
        return result;
    }

    protected void appendDebugArgument(StringBuffer sb) {
        if (this.isDebug) {
            sb.append(" -debug");
        }
    }

    protected IJavaProject getJavaProject() {
        return this.javaProject;
    }

    protected ILaunch getLaunch() {
        return this.launch;
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfig() {
        return this.launchConfig;
    }

    protected String getProjectLocation() {
        return this.projectLocation;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private IVMInstall getProjectJRE() throws CoreException {
        return JavaRuntime.getVMInstall((IJavaProject)this.javaProject);
    }

    protected IRuntimeClasspathEntry getBootstrapJarClasspathEntry() {
        return AbstractJptGenerator.getArchiveClasspathEntry(this.buildBootstrapJarPath());
    }

    protected IPath buildBootstrapJarPath() {
        return this.findGenJarStartingWith(this.getBootstrapJarPrefix());
    }

    protected IPath findGenJarStartingWith(String genJarName) {
        try {
            File jarInstallDir = this.getBundleParentDir(JptCommonCorePlugin.instance().getBundle());
            ArrayList result = new ArrayList();
            this.findFileStartingWith(genJarName, jarInstallDir, result);
            if (result.isEmpty()) {
                throw new RuntimeException("Could not find: " + genJarName + "#.#.#v###.jar in: " + jarInstallDir);
            }
            File genJarFile = (File)result.get(0);
            String genJarPath = genJarFile.getCanonicalPath();
            return new Path(genJarPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getBundleParentDir(Bundle bundle) throws IOException {
        if (Platform.inDevelopmentMode()) {
            Location eclipseHomeLoc = Platform.getInstallLocation();
            String eclipseHome = eclipseHomeLoc.getURL().getPath();
            if (!eclipseHome.endsWith(PLUGINS_DIR)) {
                eclipseHome = String.valueOf(eclipseHome) + PLUGINS_DIR;
            }
            return new File(eclipseHome);
        }
        return FileLocator.getBundleFile((Bundle)bundle).getParentFile();
    }

    private ILaunchConfigurationWorkingCopy buildLaunchConfiguration() throws CoreException {
        this.removeLaunchConfiguration();
        ILaunchManager manager = this.getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        return type.newInstance(null, this.getLaunchConfigName());
    }

    private void removeLaunchConfiguration() throws CoreException {
        ILaunchManager manager = this.getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            if (configuration.getName().equals(this.getLaunchConfigName())) {
                configuration.delete();
                break;
            }
            ++i;
        }
    }

    private void findFileStartingWith(String fileName, File directory, List<? super File> list) {
        if (directory.listFiles() == null) {
            throw new RuntimeException("Could not find directory: " + directory);
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(fileName)) {
                list.add(file);
            }
            if (file.isDirectory()) {
                this.findFileStartingWith(fileName, file, list);
            }
            ++n2;
        }
    }

    private void specifyWorkingDir() {
        File workingDir = new Path(this.projectLocation).toFile();
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, workingDir.getAbsolutePath());
    }

    protected void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    private ListenerList<LaunchConfigListener> buildLaunchConfigListenerList() {
        return new ListenerList(LaunchConfigListener.class);
    }

    @Override
    public void addLaunchConfigListener(LaunchConfigListener listener) {
        this.launchConfigListenerList.add((Object)listener);
    }

    @Override
    public void removeLaunchConfigListener(LaunchConfigListener listener) {
        this.launchConfigListenerList.remove((Object)listener);
    }
}

