/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public abstract class AbstractAnnotationAdapter
implements AnnotationAdapter {
    private final AnnotatedElement annotatedElement;
    private final DeclarationAnnotationAdapter daa;

    public AbstractAnnotationAdapter(AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa) {
        this.annotatedElement = annotatedElement;
        this.daa = daa;
    }

    public Annotation getAnnotation(CompilationUnit astRoot) {
        return this.daa.getAnnotation(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    public MarkerAnnotation newMarkerAnnotation() {
        NewMarkerAnnotationEditor editor = this.buildNewMarkerAnnotationEditor();
        this.edit(editor);
        return editor.getResult();
    }

    public SingleMemberAnnotation newSingleMemberAnnotation() {
        NewSingleMemberAnnotationEditor editor = this.buildNewSingleMemberAnnotationEditor();
        this.edit(editor);
        return editor.getResult();
    }

    public NormalAnnotation newNormalAnnotation() {
        NewNormalAnnotationEditor editor = this.buildNewNormalAnnotationEditor();
        this.edit(editor);
        return editor.getResult();
    }

    public void removeAnnotation() {
        this.edit(this.buildRemoveAnnotationEditor());
    }

    public ASTNode getAstNode(CompilationUnit astRoot) {
        return this.daa.getAstNode(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.daa);
    }

    protected void edit(AnnotatedElement.Editor editor) {
        this.annotatedElement.edit(editor);
    }

    protected NewMarkerAnnotationEditor buildNewMarkerAnnotationEditor() {
        return new NewMarkerAnnotationEditor(this.daa);
    }

    protected NewSingleMemberAnnotationEditor buildNewSingleMemberAnnotationEditor() {
        return new NewSingleMemberAnnotationEditor(this.daa);
    }

    protected NewNormalAnnotationEditor buildNewNormalAnnotationEditor() {
        return new NewNormalAnnotationEditor(this.daa);
    }

    protected AnnotatedElement.Editor buildRemoveAnnotationEditor() {
        return new RemoveAnnotationEditor(this.daa);
    }

    protected static class NewMarkerAnnotationEditor
    implements AnnotatedElement.Editor {
        private final DeclarationAnnotationAdapter daa;
        private MarkerAnnotation result;

        NewMarkerAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.result = this.daa.newMarkerAnnotation(declaration);
        }

        public MarkerAnnotation getResult() {
            return this.result;
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    protected static class NewNormalAnnotationEditor
    implements AnnotatedElement.Editor {
        private final DeclarationAnnotationAdapter daa;
        private NormalAnnotation result;

        NewNormalAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.result = this.daa.newNormalAnnotation(declaration);
        }

        public NormalAnnotation getResult() {
            return this.result;
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    protected static class NewSingleMemberAnnotationEditor
    implements AnnotatedElement.Editor {
        private final DeclarationAnnotationAdapter daa;
        private SingleMemberAnnotation result;

        NewSingleMemberAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.result = this.daa.newSingleMemberAnnotation(declaration);
        }

        public SingleMemberAnnotation getResult() {
            return this.result;
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    protected static class RemoveAnnotationEditor
    implements AnnotatedElement.Editor {
        private final DeclarationAnnotationAdapter daa;

        RemoveAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.daa.removeAnnotation(declaration);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

