/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jpt.common.core.internal.utility.jdt.AbstractAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class ElementIndexedAnnotationAdapter
extends AbstractAnnotationAdapter
implements IndexedAnnotationAdapter {
    private final IndexedDeclarationAnnotationAdapter idaa;

    public ElementIndexedAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        super(annotatedElement, idaa);
        this.idaa = idaa;
    }

    public int getIndex() {
        return this.idaa.getIndex();
    }

    public void moveAnnotation(int newIndex) {
        this.edit(this.buildMoveAnnotationEditor(newIndex));
    }

    protected AnnotatedElement.Editor buildMoveAnnotationEditor(int newIndex) {
        return new MoveAnnotationEditor(this.idaa, newIndex);
    }

    protected static class MoveAnnotationEditor
    implements AnnotatedElement.Editor {
        private final IndexedDeclarationAnnotationAdapter idaa;
        private int index;

        MoveAnnotationEditor(IndexedDeclarationAnnotationAdapter idaa, int index) {
            this.idaa = idaa;
            this.index = index;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.idaa.moveAnnotation(this.index, declaration);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

