/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.jaxrssharedlibraryconfig;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrssharedlibraryconfig.SharedLibraryConfigurator;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrssharedlibraryconfig.SharedLibraryConfiguratorCreationHelper;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedLibraryConfiguratorUtil {
    private static SharedLibraryConfiguratorUtil instance = null;
    private static List<SharedLibraryConfigurator> configurators = new Vector<SharedLibraryConfigurator>();
    private static final String SHAREDLIB_EXT_PT = "jaxrsSharedLibrarySupport";

    private SharedLibraryConfiguratorUtil() {
    }

    public static boolean isSharedLibSelectedByDefault(String targetRuntimeID) {
        if (targetRuntimeID == null) {
            return false;
        }
        SharedLibraryConfiguratorUtil.getInstance();
        List<SharedLibraryConfigurator> configurators = SharedLibraryConfiguratorUtil.getConfigurators();
        for (SharedLibraryConfigurator thisConfigurator : configurators) {
            if (!targetRuntimeID.equals(thisConfigurator.getRuntimeID())) continue;
            return thisConfigurator.getSelected();
        }
        return false;
    }

    public static boolean isSharedLibSupportAvailable(String libraryID, String targetRuntimeID, IProject webProject, IProject earProject, boolean addToEAR) {
        if (libraryID == null || targetRuntimeID == null || libraryID.length() == 0 || libraryID.length() == 0) {
            return false;
        }
        SharedLibraryConfiguratorUtil.getInstance();
        List<SharedLibraryConfigurator> configurators = SharedLibraryConfiguratorUtil.getConfigurators();
        for (SharedLibraryConfigurator thisConfigurator : configurators) {
            if (!targetRuntimeID.equals(thisConfigurator.getRuntimeID()) || !thisConfigurator.getIsSharedLibSupported(webProject, earProject, addToEAR, libraryID)) continue;
            return true;
        }
        return false;
    }

    public static synchronized SharedLibraryConfiguratorUtil getInstance() {
        if (instance == null) {
            instance = new SharedLibraryConfiguratorUtil();
            instance.loadSharedLibraryConfiguratorExtensions();
        }
        return instance;
    }

    private void loadSharedLibraryConfiguratorExtensions() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.jaxrs.core", SHAREDLIB_EXT_PT);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    SharedLibraryConfiguratorCreationHelper newLibCreator = new SharedLibraryConfiguratorCreationHelper(ext.getConfigurationElements()[j]);
                    SharedLibraryConfigurator newconfigurator = newLibCreator.create();
                    if (newconfigurator != null) {
                        configurators.add(newconfigurator);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            JAXRSCorePlugin.log(4, Messages.JAXRSSharedLibraryConfigurator_ErrorLoadingFromExtPt, e);
        }
    }

    public static boolean getAddToEar(IDataModel model) {
        return model.getBooleanProperty("IJAXRSFacetInstallDataModelProperties.ADD_TO_EAR");
    }

    public static IProject getEARProject(IDataModel model) {
        String projName = model.getStringProperty("IJAXRSFacetInstallDataModelProperties.EARPROJECT_NAME");
        if (projName == null || "".equals(projName)) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return project;
    }

    public static IProject getWebProject(IDataModel model) {
        String projName = model.getStringProperty("IJAXRSFacetInstallDataModelProperties.WEBPROJECT_NAME");
        if (projName == null || "".equals(projName)) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return project;
    }

    public static List<SharedLibraryConfigurator> getConfigurators() {
        return configurators;
    }
}

