/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import java.util.Comparator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseObject;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPTableWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DTPSchemaContainerWrapper<P extends DTPDatabaseObject, S extends SQLObject>
extends DTPDatabaseObjectWrapper<P, S>
implements SchemaContainer {
    private DTPSchemaWrapper[] schemata;

    DTPSchemaContainerWrapper(P parent, S dtpObject) {
        super(parent, dtpObject);
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
    }

    abstract List<org.eclipse.datatools.modelbase.sql.schema.Schema> getDTPSchemas();

    abstract DTPSchemaWrapper getSchema(org.eclipse.datatools.modelbase.sql.schema.Schema var1);

    DTPSchemaWrapper getSchema_(org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema) {
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.getSchemaArray();
        int n = dTPSchemaWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            if (schema.wraps(dtpSchema)) {
                return schema;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP schema: " + dtpSchema);
    }

    abstract DTPTableWrapper getTable(Table var1);

    DTPTableWrapper getTable_(Table dtpTable) {
        return this.getSchema_(dtpTable.getSchema()).getTable_(dtpTable);
    }

    abstract DTPColumnWrapper getColumn(Column var1);

    DTPColumnWrapper getColumn_(Column dtpColumn) {
        return this.getTable_(dtpColumn.getTable()).getColumn_(dtpColumn);
    }

    @Override
    public Iterable<Schema> getSchemata() {
        return IterableTools.iterable((Object[])this.getSchemaArray());
    }

    Iterable<DTPSchemaWrapper> getSchemaWrappers() {
        return IterableTools.iterable((Object[])this.getSchemaArray());
    }

    synchronized DTPSchemaWrapper[] getSchemaArray() {
        if (this.schemata == null) {
            this.schemata = this.buildSchemaArray();
        }
        return this.schemata;
    }

    private DTPSchemaWrapper[] buildSchemaArray() {
        List<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata = this.getDTPSchemas();
        Object[] result = new DTPSchemaWrapper[dtpSchemata.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPSchemaWrapper(this, dtpSchemata.get(i));
        }
        return (DTPSchemaWrapper[])ArrayTools.sort((Object[])result, (Comparator)DEFAULT_COMPARATOR);
    }

    @Override
    public int getSchemataSize() {
        return this.getSchemaArray().length;
    }

    @Override
    public Iterable<String> getSortedSchemaNames() {
        return new TransformationIterable(this.getSchemaWrappers(), NAME_TRANSFORMER);
    }

    @Override
    public DTPSchemaWrapper getSchemaNamed(String name) {
        return this.selectDatabaseObjectNamed(this.getSchemaWrappers(), name);
    }

    @Override
    public Iterable<String> getSortedSchemaIdentifiers() {
        return new TransformationIterable(this.getSchemaWrappers(), IDENTIFIER_TRANSFORMER);
    }

    @Override
    public Schema getSchemaForIdentifier(String identifier) {
        return this.getDTPDriverAdapter().selectSchemaForIdentifier(this.getSchemata(), identifier);
    }

    @Override
    public DTPSchemaWrapper getDefaultSchema() {
        return this.getSchemaForNames(this.getDTPDriverAdapter().getDefaultSchemaNames());
    }

    DTPSchemaWrapper getSchemaForNames(Iterable<String> names) {
        for (String name : names) {
            DTPSchemaWrapper schema = this.getSchemaNamed(name);
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    @Override
    public synchronized String getDefaultSchemaIdentifier() {
        Iterable<String> names = this.getDTPDriverAdapter().getDefaultSchemaNames();
        DTPSchemaWrapper schema = this.getSchemaForNames(names);
        return schema != null ? schema.getIdentifier() : this.convertNameToIdentifier((String)IterableTools.last(names));
    }

    @Override
    synchronized void startListening() {
        if (this.schemata != null) {
            this.startSchemata();
        }
        super.startListening();
    }

    private void startSchemata() {
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
        int n = this.schemata.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            schema.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.schemata != null) {
            this.stopSchemata();
        }
        super.stopListening();
    }

    private void stopSchemata() {
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
        int n = this.schemata.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            schema.stopListening();
            ++n2;
        }
    }

    @Override
    synchronized void clear() {
        if (this.schemata != null) {
            this.clearSchemata();
        }
    }

    private void clearSchemata() {
        this.stopSchemata();
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
        int n = this.schemata.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            schema.clear();
            ++n2;
        }
        this.schemata = null;
    }
}

