/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.filters;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.logging.aeri.core.util.StatusSwitch;
import org.eclipse.jdt.annotation.Nullable;

public class RequiredPackagesFilter
implements Predicate<IStatus> {
    private List<Pattern> patterns;

    public RequiredPackagesFilter(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    public boolean apply(IStatus input) {
        if (this.patterns.isEmpty()) {
            return true;
        }
        RequiredPackageSwitch test = new RequiredPackageSwitch();
        TestResult res = (TestResult)((Object)Objects.firstNonNull((Object)((Object)((TestResult)((Object)test.doSwitch(input)))), (Object)((Object)TestResult.UNDEF)));
        switch (res) {
            case PASS: {
                return true;
            }
        }
        return false;
    }

    private final class RequiredPackageSwitch
    extends StatusSwitch<TestResult> {
        private RequiredPackageSwitch() {
        }

        @Override
        @Nullable
        public TestResult caseStackTraceElement(StackTraceElement stackTraceElement) {
            String label = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
            for (Pattern pattern : RequiredPackagesFilter.this.patterns) {
                if (!pattern.matcher(label).matches()) continue;
                return TestResult.PASS;
            }
            return null;
        }
    }

    static enum TestResult {
        PASS,
        FAIL,
        UNDEF;

    }
}

