/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm;

import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.TypeName;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmAttributeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmAttributeMappingDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFileDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.ELXmlAccessType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EJavaAttribute;

public class OxmJavaAttributeImpl
extends AbstractJaxbContextNode
implements OxmJavaAttribute {
    protected String javaAttributeName;
    protected XmlAccessType accessType;
    protected XmlAccessType defaultAccessType;
    protected XmlAccessType specifiedAccessType;
    protected static final String JAVA_RESOURCE_ATTRIBUTE_PROPERTY = "javaResourceAttribute";
    protected JavaResourceAttribute javaResourceAttribute;
    protected OxmAttributeMapping mapping;

    protected OxmJavaAttributeImpl(OxmJavaType parent, EJavaAttribute eJavaAttribute) {
        super((JaxbNode)parent);
        this.initMapping(eJavaAttribute);
        this.initJavaAttributeName();
        this.initAccessType();
    }

    public OxmJavaType getClassMapping() {
        return (OxmJavaType)this.getParent();
    }

    protected OxmFileDefinition getOxmFileDefinition() {
        return this.getClassMapping().getXmlBindings().getOxmFile().getDefinition();
    }

    public EJavaAttribute getEJavaAttribute() {
        return this.mapping.getEJavaAttribute();
    }

    public String getName() {
        return this.getJavaAttributeName();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncJavaAttributeName();
        this.syncAccessType();
        this.syncMapping();
    }

    public void update() {
        super.update();
        this.updateAccessType();
        this.updateMapping();
    }

    public String getJavaAttributeName() {
        return this.javaAttributeName;
    }

    public void setJavaAttributeName(String newName) {
        this.getEJavaAttribute().setJavaAttribute(newName);
        this.setJavaAttributeName_(newName);
    }

    protected void setJavaAttributeName_(String newName) {
        String oldName = this.javaAttributeName;
        this.javaAttributeName = newName;
        this.firePropertyChanged("javaAttributeName", oldName, newName);
    }

    protected String getResourceJavaAttributeName() {
        return this.getEJavaAttribute().getJavaAttribute();
    }

    protected void initJavaAttributeName() {
        this.javaAttributeName = this.getResourceJavaAttributeName();
    }

    protected void syncJavaAttributeName() {
        this.setJavaAttributeName_(this.getResourceJavaAttributeName());
    }

    public XmlAccessType getAccessType() {
        return this.accessType;
    }

    protected void setAccessType_(XmlAccessType accessType) {
        XmlAccessType old = this.accessType;
        this.accessType = accessType;
        this.firePropertyChanged("accessType", old, accessType);
    }

    public XmlAccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    protected void setDefaultAccessType_(XmlAccessType accessType) {
        XmlAccessType old = this.defaultAccessType;
        this.defaultAccessType = accessType;
        this.firePropertyChanged("defaultAccessType", old, accessType);
    }

    public XmlAccessType getSpecifiedAccessType() {
        return this.specifiedAccessType;
    }

    public void setSpecifiedAccessType(XmlAccessType accessType) {
        this.setSpecifiedAccessType_(accessType);
        this.getEJavaAttribute().setXmlAccessorType(ELXmlAccessType.toOxmResourceModel(accessType));
    }

    protected void setSpecifiedAccessType_(XmlAccessType accessType) {
        XmlAccessType old = this.specifiedAccessType;
        this.specifiedAccessType = accessType;
        this.firePropertyChanged("specifiedAccessType", old, accessType);
    }

    protected void initAccessType() {
        this.specifiedAccessType = this.getResourceAccessType();
    }

    protected void syncAccessType() {
        this.setSpecifiedAccessType_(this.getResourceAccessType());
    }

    protected void updateAccessType() {
        XmlAccessType defaultAccessType = this.getClassMapping().getAccessType();
        this.setDefaultAccessType_(defaultAccessType);
        XmlAccessType accessType = this.specifiedAccessType != null ? this.specifiedAccessType : this.defaultAccessType;
        this.setAccessType_(accessType);
    }

    protected XmlAccessType getResourceAccessType() {
        return ELXmlAccessType.fromOxmResourceModel(this.getEJavaAttribute().getXmlAccessorType());
    }

    public OxmAttributeMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping_(OxmAttributeMapping mapping) {
        OxmAttributeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
        this.getClassMapping().attributeMappingChanged(this, old, mapping);
    }

    public String getMappingKey() {
        return this.mapping.getKey();
    }

    public JaxbAttributeMapping setMappingKey(String key) {
        if (ObjectTools.notEquals((Object)this.getMappingKey(), (Object)key)) {
            OxmAttributeMappingDefinition mappingDefinition = this.getOxmFileDefinition().getAttributeMappingDefinitionForKey(key);
            EJavaAttribute eJavaAttribute = mappingDefinition.buildEJavaAttribute();
            this.setMapping_(mappingDefinition.buildContextMapping(this, eJavaAttribute));
        }
        return this.mapping;
    }

    protected void initMapping(EJavaAttribute eJavaAttribute) {
        OxmAttributeMappingDefinition mappingDef = this.getOxmFileDefinition().getAttributeMappingDefinitionForElement(eJavaAttribute.getElementName());
        this.mapping = mappingDef.buildContextMapping(this, eJavaAttribute);
    }

    protected void syncMapping() {
        this.mapping.synchronizeWithResourceModel();
    }

    protected void updateMapping() {
        this.mapping.update();
    }

    public boolean isInherited() {
        return ObjectTools.notEquals((Object)this.getDeclaringTypeName(), (Object)this.getClassMapping().getTypeName());
    }

    public TypeName getDeclaringTypeName() {
        return this.getClassMapping().getTypeName();
    }

    public String getJavaResourceAttributeBaseTypeName() {
        return Object.class.getName();
    }

    public boolean isJavaResourceAttributeCollectionType() {
        return false;
    }

    public boolean isJavaResourceAttributeTypeSubTypeOf(String typeName) {
        return false;
    }
}

