/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextModelFactory;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.orm.OrmElementCollectionTemporalConverterValidator;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.orm.OrmMapKeyTemporalConverterValidator;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.orm.OrmTemporalConverterValidator;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlMapKeyConvertibleMapping_2_0;

public interface OrmBaseTemporalConverter
extends BaseTemporalConverter,
OrmConverter {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractAdapter
    implements OrmConverter.Adapter {
        AbstractAdapter() {
        }

        public Class<BaseTemporalConverter> getConverterType() {
            return BaseTemporalConverter.class;
        }

        @Override
        public OrmConverter buildConverter(OrmAttributeMapping parent, OrmXmlContextModelFactory factory) {
            XmlConvertibleMapping xmlMapping = (XmlConvertibleMapping)((Object)parent.getXmlAttributeMapping());
            return xmlMapping.getTemporal() == null ? null : factory.buildOrmBaseTemporalConverter(this.buildParentAdapter(parent, xmlMapping));
        }

        protected abstract ParentAdapter buildParentAdapter(OrmAttributeMapping var1, XmlConvertibleMapping var2);

        @Override
        public boolean isActive(XmlAttributeMapping xmlMapping) {
            return ((XmlConvertibleMapping)((Object)xmlMapping)).getTemporal() != null;
        }

        @Override
        public OrmConverter buildNewConverter(OrmAttributeMapping parent, OrmXmlContextModelFactory factory) {
            return factory.buildOrmBaseTemporalConverter(this.buildParentAdapter(parent, (XmlConvertibleMapping)((Object)parent.getXmlAttributeMapping())));
        }

        @Override
        public void clearXmlValue(XmlAttributeMapping xmlMapping) {
            ((XmlConvertibleMapping)((Object)xmlMapping)).setTemporal(null);
        }

        public static abstract class ConverterParentAdapter
        implements ParentAdapter {
            private final OrmAttributeMapping parent;
            private final XmlConvertibleMapping mapping;

            public ConverterParentAdapter(OrmAttributeMapping parent, XmlConvertibleMapping mapping) {
                this.parent = parent;
                this.mapping = mapping;
            }

            public OrmAttributeMapping getConverterParent() {
                return this.parent;
            }

            public void setXmlTemporalType(TemporalType temporalType) {
                this.mapping.setTemporal(temporalType);
            }

            public TemporalType getXmlTemporalType() {
                return this.mapping.getTemporal();
            }

            public TextRange getTemporalTextRange() {
                return this.mapping.getTemporalTextRange();
            }
        }
    }

    public static class BasicAdapter
    extends AbstractAdapter {
        private static final OrmConverter.Adapter INSTANCE = new BasicAdapter();

        public static OrmConverter.Adapter instance() {
            return INSTANCE;
        }

        private BasicAdapter() {
        }

        protected ParentAdapter buildParentAdapter(OrmAttributeMapping parent, XmlConvertibleMapping mapping) {
            return new ConverterParentAdapter(parent, mapping);
        }

        public static class ConverterParentAdapter
        extends AbstractAdapter.ConverterParentAdapter {
            public ConverterParentAdapter(OrmAttributeMapping parent, XmlConvertibleMapping mapping) {
                super(parent, mapping);
            }

            public JpaValidator buildValidator(Converter converter) {
                return new OrmTemporalConverterValidator((BaseTemporalConverter)converter);
            }
        }
    }

    public static class ElementCollectionAdapter
    extends AbstractAdapter {
        private static final OrmConverter.Adapter INSTANCE = new ElementCollectionAdapter();

        public static OrmConverter.Adapter instance() {
            return INSTANCE;
        }

        private ElementCollectionAdapter() {
        }

        protected ParentAdapter buildParentAdapter(OrmAttributeMapping parent, XmlConvertibleMapping mapping) {
            return new ConverterParentAdapter(parent, mapping);
        }

        public static class ConverterParentAdapter
        extends AbstractAdapter.ConverterParentAdapter {
            public ConverterParentAdapter(OrmAttributeMapping parent, XmlConvertibleMapping mapping) {
                super(parent, mapping);
            }

            public JpaValidator buildValidator(Converter converter) {
                return new OrmElementCollectionTemporalConverterValidator((BaseTemporalConverter)converter);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapKeyAdapter
    implements OrmConverter.Adapter {
        private static final MapKeyAdapter INSTANCE = new MapKeyAdapter();

        public static MapKeyAdapter instance() {
            return INSTANCE;
        }

        private MapKeyAdapter() {
        }

        public Class<BaseTemporalConverter> getConverterType() {
            return BaseTemporalConverter.class;
        }

        @Override
        public OrmConverter buildConverter(OrmAttributeMapping parent, OrmXmlContextModelFactory factory) {
            XmlMapKeyConvertibleMapping_2_0 xmlMapping = (XmlMapKeyConvertibleMapping_2_0)((Object)parent.getXmlAttributeMapping());
            return xmlMapping.getMapKeyTemporal() == null ? null : factory.buildOrmBaseTemporalConverter(this.buildParentAdapter(parent, xmlMapping));
        }

        protected ParentAdapter buildParentAdapter(OrmAttributeMapping parent, XmlMapKeyConvertibleMapping_2_0 mapping) {
            return new ConverterParentAdapter(parent, mapping);
        }

        @Override
        public boolean isActive(XmlAttributeMapping xmlMapping) {
            return ((XmlMapKeyConvertibleMapping_2_0)((Object)xmlMapping)).getMapKeyTemporal() != null;
        }

        @Override
        public OrmConverter buildNewConverter(OrmAttributeMapping parent, OrmXmlContextModelFactory factory) {
            return factory.buildOrmBaseTemporalConverter(this.buildParentAdapter(parent, (XmlMapKeyConvertibleMapping_2_0)((Object)parent.getXmlAttributeMapping())));
        }

        @Override
        public void clearXmlValue(XmlAttributeMapping xmlMapping) {
            ((XmlMapKeyConvertibleMapping_2_0)((Object)xmlMapping)).setMapKeyTemporal(null);
        }

        public static class ConverterParentAdapter
        implements ParentAdapter {
            private final OrmAttributeMapping parent;
            private final XmlMapKeyConvertibleMapping_2_0 mapping;

            public ConverterParentAdapter(OrmAttributeMapping parent, XmlMapKeyConvertibleMapping_2_0 mapping) {
                this.parent = parent;
                this.mapping = mapping;
            }

            public OrmAttributeMapping getConverterParent() {
                return this.parent;
            }

            public void setXmlTemporalType(TemporalType temporalType) {
                this.mapping.setMapKeyTemporal(temporalType);
            }

            public TemporalType getXmlTemporalType() {
                return this.mapping.getMapKeyTemporal();
            }

            public TextRange getTemporalTextRange() {
                return this.mapping.getMapKeyTemporalTextRange();
            }

            public JpaValidator buildValidator(Converter converter) {
                return new OrmMapKeyTemporalConverterValidator((BaseTemporalConverter)converter);
            }
        }
    }

    public static interface ParentAdapter
    extends OrmConverter.ParentAdapter {
        public TemporalType getXmlTemporalType();

        public void setXmlTemporalType(TemporalType var1);

        public TextRange getTemporalTextRange();
    }
}

