/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.IdTypeMapping;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaManagedType;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.AccessAnnotation2_0;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentType
extends AbstractJavaManagedType<PersistentType.Parent>
implements JavaPersistentType {
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected JavaTypeMapping mapping;
    protected final Vector<JavaSpecifiedPersistentAttribute> attributes = new Vector();
    protected final Vector<JavaSpecifiedPersistentAttribute> structureChildren = new Vector();

    protected AbstractJavaPersistentType(PersistentType.Parent parent, JavaResourceType resourceType) {
        super(parent, resourceType);
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.defaultAccess = AccessType.FIELD;
        this.mapping = this.buildMapping();
        this.initializeAttributes();
        this.initializeStructureChildren();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.syncMapping();
        this.synchronizeModelsWithResourceModel((Iterable<? extends JpaContextModel>)this.getAttributes());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.mapping.update();
        this.updateAttributes();
        this.updateStructureChildren();
    }

    @Override
    public PersistentType getSuperPersistentType() {
        IdTypeMapping superTypeMapping = this.mapping.getSuperTypeMapping();
        return superTypeMapping == null ? null : superTypeMapping.getPersistentType();
    }

    protected AccessAnnotation2_0 getAccessAnnotation() {
        return (AccessAnnotation2_0)this.resourceType.getNonNullAnnotation(this.getAccessAnnotationName());
    }

    protected void removeAccessAnnotationIfUnset() {
        AccessAnnotation2_0 accessAnnotation = this.getAccessAnnotation();
        if (accessAnnotation != null && accessAnnotation.isUnset()) {
            this.removeAccessAnnotation();
        }
    }

    protected void removeAccessAnnotation() {
        this.resourceType.removeAnnotation(this.getAccessAnnotationName());
    }

    protected String getAccessAnnotationName() {
        return "javax.persistence.Access";
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        if (ObjectTools.notEquals((Object)this.specifiedAccess, (Object)access)) {
            this.getAccessAnnotation().setValue(AccessType.toJavaResourceModel(access));
            this.removeAccessAnnotationIfUnset();
            this.setSpecifiedAccess_(access);
        }
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", old, access);
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromJavaResourceModel(this.getAccessAnnotation().getValue(), this.getJpaPlatform(), this.getResourceType());
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", old, access);
    }

    protected AccessType buildDefaultAccess() {
        AccessType accessType = this.getResourceTypeAccess();
        if (accessType != null) {
            return accessType;
        }
        accessType = ((PersistentType.Parent)this.parent).getOverridePersistentTypeAccess();
        if (accessType != null) {
            return accessType;
        }
        if (this.getSuperPersistentType() != null && (accessType = this.getSuperPersistentType().getAccess()) != null) {
            return accessType;
        }
        accessType = ((PersistentType.Parent)this.parent).getDefaultPersistentTypeAccess();
        if (accessType != null) {
            return accessType;
        }
        return AccessType.FIELD;
    }

    protected AccessType getResourceTypeAccess() {
        for (JavaResourceField field : this.resourceType.getFields()) {
            if (!field.isAnnotated()) continue;
            return AccessType.FIELD;
        }
        for (JavaResourceMethod method : this.resourceType.getMethods()) {
            if (!method.isAnnotated()) continue;
            return AccessType.PROPERTY;
        }
        return null;
    }

    @Override
    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public void setMappingKey(String key) {
        if (ObjectTools.notEquals((Object)key, (Object)this.getMappingKey())) {
            this.setMapping(this.buildMapping(key));
        }
    }

    protected JavaTypeMapping buildMapping(String key) {
        for (JavaTypeMappingDefinition definition : this.getMappingDefinitions()) {
            if (!ObjectTools.equals((Object)definition.getKey(), (Object)key)) continue;
            Annotation annotation = this.resourceType.setPrimaryAnnotation(definition.getAnnotationName(), definition.getSupportingAnnotationNames());
            return definition.buildMapping(this, annotation, this.getJpaFactory());
        }
        this.resourceType.setPrimaryAnnotation(null, EmptyIterable.instance());
        return this.buildNullMapping();
    }

    protected void setMapping(JavaTypeMapping mapping) {
        JavaTypeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
    }

    protected JavaTypeMapping buildMapping() {
        for (JavaTypeMappingDefinition definition : this.getMappingDefinitions()) {
            Annotation annotation = this.resourceType.getAnnotation(definition.getAnnotationName());
            if (annotation == null) continue;
            return definition.buildMapping(this, annotation, this.getJpaFactory());
        }
        return this.buildNullMapping();
    }

    protected void syncMapping() {
        JavaTypeMappingDefinition definition = null;
        Annotation annotation = null;
        Iterator<JavaTypeMappingDefinition> stream = this.mappingDefinitions();
        while (stream.hasNext()) {
            definition = stream.next();
            annotation = this.resourceType.getAnnotation(definition.getAnnotationName());
            if (annotation != null) break;
        }
        if (this.mapping.getMappingAnnotation() == annotation) {
            this.mapping.synchronizeWithResourceModel();
        } else {
            this.setMapping(this.buildMapping(annotation, definition));
        }
    }

    protected JavaTypeMapping buildMapping(Annotation annotation, JavaTypeMappingDefinition definition) {
        return annotation != null ? definition.buildMapping(this, annotation, this.getJpaFactory()) : this.buildNullMapping();
    }

    protected Iterator<JavaTypeMappingDefinition> mappingDefinitions() {
        return this.getMappingDefinitions().iterator();
    }

    protected Iterable<JavaTypeMappingDefinition> getMappingDefinitions() {
        return this.getJpaPlatform().getJavaTypeMappingDefinitions();
    }

    protected JavaTypeMapping buildNullMapping() {
        return this.getJpaFactory().buildJavaNullTypeMapping(this);
    }

    @Override
    public boolean isMapped() {
        return this.mapping.isMapped();
    }

    @Override
    public ListIterable<JavaSpecifiedPersistentAttribute> getAttributes() {
        return IterableTools.cloneLive(this.attributes);
    }

    @Override
    public int getAttributesSize() {
        return this.attributes.size();
    }

    @Override
    public Iterable<String> getAttributeNames() {
        return this.convertToNames((Iterable<? extends PersistentAttribute>)this.getAttributes());
    }

    @Override
    public JavaSpecifiedPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<JavaSpecifiedPersistentAttribute> stream = this.getAttributesNamed(attributeName).iterator();
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public JavaSpecifiedPersistentAttribute getAttributeFor(JavaResourceAttribute javaResourceAttribute) {
        for (JavaSpecifiedPersistentAttribute javaAttribute : this.getAttributes()) {
            if (javaAttribute.getResourceAttribute() != javaResourceAttribute) continue;
            return javaAttribute;
        }
        return null;
    }

    @Override
    public Iterable<PersistentAttribute> getAllAttributes() {
        return IterableTools.children(this.getInheritanceHierarchy(), PersistentType.ATTRIBUTES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllAttributeNames() {
        return this.convertToNames(this.getAllAttributes());
    }

    protected Iterable<JavaSpecifiedPersistentAttribute> getAttributesNamed(String attributeName) {
        return IterableTools.filter(this.getAttributes(), (Predicate)new PersistentAttribute.NameEquals(attributeName));
    }

    @Override
    public PersistentAttribute resolveAttribute(String attributeName) {
        Iterator<JavaSpecifiedPersistentAttribute> stream = this.getAttributesNamed(attributeName).iterator();
        if (stream.hasNext()) {
            JavaSpecifiedPersistentAttribute attribute = stream.next();
            return stream.hasNext() ? null : attribute;
        }
        return this.getSuperPersistentType() == null ? null : this.getSuperPersistentType().resolveAttribute(attributeName);
    }

    protected Iterable<String> convertToNames(Iterable<? extends PersistentAttribute> attrs) {
        return IterableTools.transform(attrs, PersistentAttribute.NAME_TRANSFORMER);
    }

    protected JavaSpecifiedPersistentAttribute buildField(JavaResourceField resourceField) {
        return this.getJpaFactory().buildJavaPersistentField(this, resourceField);
    }

    protected JavaSpecifiedPersistentAttribute buildProperty(JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        return this.getJpaFactory().buildJavaPersistentProperty(this, resourceGetter, resourceSetter);
    }

    @Override
    public boolean hasAnyAnnotatedAttributes() {
        return this.resourceType.hasAnyAnnotatedFields() || this.resourceType.hasAnyAnnotatedMethods();
    }

    protected void moveAttribute(int index, JavaSpecifiedPersistentAttribute attribute) {
        this.moveItemInList(index, attribute, this.attributes, "attributes");
    }

    protected void addAttribute(int index, JavaSpecifiedPersistentAttribute persistentAttribute) {
        this.addItemToList(index, persistentAttribute, this.attributes, "attributes");
    }

    protected void removeAttribute(JavaSpecifiedPersistentAttribute attribute) {
        this.removeItemFromList(attribute, this.attributes, "attributes");
    }

    protected void initializeAttributes() {
        if (this.getAccess() == AccessType.FIELD) {
            this.intializeFieldAccessAttributes();
        } else if (this.getAccess() == AccessType.PROPERTY) {
            this.intializePropertyAccessAttributes();
        }
    }

    private void intializeFieldAccessAttributes() {
        this.initializeFieldAttributes((Predicate<? super JavaResourceField>)JavaResourceField.IS_RELEVANT_FOR_FIELD_ACCESS);
        this.initializeAnnotatedPropertyAttributes();
    }

    private void initializeFieldAttributes(Predicate<? super JavaResourceField> filter) {
        for (JavaResourceField resourceField : this.getResourceFields(filter)) {
            this.attributes.add(this.buildField(resourceField));
        }
    }

    private void intializePropertyAccessAttributes() {
        this.initializeFieldAttributes((Predicate<? super JavaResourceField>)JavaResourceAnnotatedElement.IS_ANNOTATED);
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod;
            if (this.includeProperty(getterMethod, setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod))) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    private void initializeAnnotatedPropertyAttributes() {
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod);
            if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    private void initializeRemainingResourceMethodAttributes(Collection<JavaResourceMethod> resourceMethods) {
        for (JavaResourceMethod resourceMethod : resourceMethods) {
            if (!resourceMethod.isAnnotated()) continue;
            this.attributes.add(this.buildProperty(null, resourceMethod));
        }
    }

    protected void updateAttributes() {
        if (this.getAccess() == AccessType.FIELD) {
            this.syncFieldAccessAttributes();
        } else if (this.getAccess() == AccessType.PROPERTY) {
            this.syncPropertyAccessAttributes();
        }
    }

    private void syncFieldAccessAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, (Predicate<? super JavaResourceField>)JavaResourceField.IS_RELEVANT_FOR_FIELD_ACCESS);
        this.syncAnnotatedPropertyAttributes(contextAttributes);
    }

    private void syncPropertyAccessAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, (Predicate<? super JavaResourceField>)JavaResourceAnnotatedElement.IS_ANNOTATED);
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod;
            if (this.includeProperty(getterMethod, setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod))) {
                boolean match = false;
                Iterator stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    JavaSpecifiedPersistentAttribute contextAttribute = (JavaSpecifiedPersistentAttribute)stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addAttribute(this.getAttributesSize(), this.buildProperty(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncAnnotatedPropertyAttributes(HashSet<JavaSpecifiedPersistentAttribute> contextAttributes) {
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod);
            if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
                boolean match = false;
                Iterator<JavaSpecifiedPersistentAttribute> stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    JavaSpecifiedPersistentAttribute contextAttribute = stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addAttribute(this.getAttributesSize(), this.buildProperty(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncFieldAttributes(HashSet<JavaSpecifiedPersistentAttribute> contextAttributes, Predicate<? super JavaResourceField> filter) {
        for (JavaResourceField resourceField : this.getResourceFields(filter)) {
            boolean match = false;
            Iterator<JavaSpecifiedPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JavaSpecifiedPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(resourceField)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addAttribute(this.getAttributesSize(), this.buildField(resourceField));
        }
    }

    private void syncRemainingResourceMethods(HashSet<JavaSpecifiedPersistentAttribute> contextAttributes, Collection<JavaResourceMethod> resourceMethods) {
        for (JavaResourceMethod resourceMethod : resourceMethods) {
            if (!resourceMethod.isAnnotated()) continue;
            boolean match = false;
            Iterator<JavaSpecifiedPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JavaSpecifiedPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(null, resourceMethod)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addAttribute(this.getAttributesSize(), this.buildProperty(null, resourceMethod));
        }
        for (JavaSpecifiedPersistentAttribute contextAttribute : contextAttributes) {
            this.removeAttribute(contextAttribute);
        }
    }

    protected Iterable<JavaResourceField> getResourceFields() {
        return this.resourceType.getFields();
    }

    protected Iterable<JavaResourceMethod> getResourceMethods() {
        return this.resourceType.getMethods();
    }

    protected Iterable<JavaResourceField> getResourceFields(Predicate<? super JavaResourceField> filter) {
        return IterableTools.filter(this.getResourceFields(), filter);
    }

    protected Iterable<JavaResourceMethod> getResourcePropertyGetters() {
        return this.filterResourceMethods((Predicate<JavaResourceMethod>)JavaResourceMethod.IS_PROPERTY_GETTER);
    }

    protected Iterable<JavaResourceMethod> filterResourceMethods(Predicate<JavaResourceMethod> predicate) {
        return IterableTools.filter(this.getResourceMethods(), predicate);
    }

    protected boolean includeProperty(JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        return setterMethod != null || getterMethod.isAnnotated();
    }

    @Override
    public Iterable<PersistentType> getInheritanceHierarchy() {
        return IterableTools.insert((Object)this, this.getAncestors());
    }

    @Override
    public Iterable<PersistentType> getAncestors() {
        return IterableTools.transform(this.getMapping().getAncestors(), TypeMapping.PERSISTENT_TYPE_TRANSFORMER);
    }

    protected Iterable<JavaResourceType> getResourceInheritanceHierarchy() {
        return this.resourceType == null ? IterableTools.emptyIterable() : ObjectTools.chain((Object)this.resourceType, (Transformer)new SuperJavaResourceTypeTransformer());
    }

    protected JavaResourceType getJavaResourceType(String jrtName) {
        return (JavaResourceType)this.getJpaProject().getJavaResourceType(jrtName, JavaResourceAnnotatedElement.AstNodeType.TYPE);
    }

    @Override
    public TypeBinding getAttributeTypeBinding(PersistentAttribute attribute) {
        JavaResourceAttribute resourceAttribute = attribute.getJavaPersistentAttribute().getResourceAttribute();
        if (resourceAttribute == null) {
            return null;
        }
        for (JavaResourceType jrt : this.getResourceInheritanceHierarchy()) {
            TypeBinding attributeType = jrt.getAttributeTypeBinding(resourceAttribute);
            if (attributeType == null) continue;
            return attributeType;
        }
        throw new IllegalArgumentException(attribute.toString());
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    @Override
    public Class<PersistentType> getManagedTypeType() {
        return PersistentType.class;
    }

    @Override
    public Class<JavaPersistentType> getStructureType() {
        return JavaPersistentType.class;
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        this.resourceType.getJavaResourceCompilationUnit().synchronizeWithJavaSourceIfNecessary();
        if (this.containsOffset(offset)) {
            for (JpaStructureNode jpaStructureNode : this.getStructureChildren()) {
                if (!jpaStructureNode.containsOffset(offset)) continue;
                return jpaStructureNode;
            }
            return this;
        }
        return null;
    }

    @Override
    public TextRange getFullTextRange() {
        return this.resourceType.getTextRange();
    }

    @Override
    public boolean containsOffset(int offset) {
        TextRange fullTextRange = this.getFullTextRange();
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    @Override
    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
        if (ObjectTools.equals((Object)this.getResource(), (Object)jpaFile.getFile())) {
            for (JpaStructureNode root : rootStructureNodes) {
                JavaManagedType jmt = (JavaManagedType)((Object)root);
                if (!jmt.getName().equals(this.name)) continue;
                return;
            }
            rootStructureNodes.add(this);
        }
    }

    protected void initializeStructureChildren() {
        this.structureChildren.addAll(this.attributes);
    }

    protected void updateStructureChildren() {
        this.synchronizeCollection((Iterable)this.getAttributes(), this.structureChildren, "structureChildren");
    }

    public Iterable<JavaSpecifiedPersistentAttribute> getStructureChildren() {
        return IterableTools.cloneLive(this.structureChildren);
    }

    @Override
    public int getStructureChildrenSize() {
        return this.structureChildren.size();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        Iterable<String> values = this.mapping.getCompletionProposals(pos);
        if (values != null) {
            return values;
        }
        for (JavaSpecifiedPersistentAttribute attribute : this.getAttributes()) {
            values = attribute.getCompletionProposals(pos);
            if (values == null) continue;
            return values;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (MappingTools.modelIsInternalSource(this, (JavaResourceModel)this.resourceType)) {
            this.validateMapping(messages, reporter);
            this.validateAttributes(messages, reporter);
        }
    }

    protected void validateMapping(List<IMessage> messages, IReporter reporter) {
        try {
            this.mapping.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.instance().logError(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, IReporter reporter) {
        for (JavaSpecifiedPersistentAttribute attribute : this.getAttributes()) {
            this.validateAttribute(attribute, reporter, messages);
        }
    }

    protected void validateAttribute(JavaSpecifiedPersistentAttribute attribute, IReporter reporter, List<IMessage> messages) {
        try {
            attribute.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.instance().logError(t);
        }
    }

    @Override
    public PersistentType getOverriddenPersistentType() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SuperJavaResourceTypeTransformer
    extends TransformerAdapter<JavaResourceType, JavaResourceType> {
        private final HashSet<JavaResourceType> visitedResourceTypes = new HashSet();

        protected SuperJavaResourceTypeTransformer() {
        }

        public JavaResourceType transform(JavaResourceType jrt) {
            this.visitedResourceTypes.add(jrt);
            String superclassName = jrt.getSuperclassQualifiedName();
            if (superclassName == null) {
                return null;
            }
            JavaResourceType superJRT = AbstractJavaPersistentType.this.getJavaResourceType(superclassName);
            return superJRT == null || this.visitedResourceTypes.contains(superJRT) ? null : superJRT;
        }
    }
}

