/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumnContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmJoinColumnRelationshipStrategy<P extends OrmJoinColumnRelationship>
extends AbstractOrmXmlContextModel<P>
implements OrmSpecifiedJoinColumnRelationshipStrategy {
    protected final AbstractJpaContextModel.ContextListContainer<OrmSpecifiedJoinColumn, XmlJoinColumn> specifiedJoinColumnContainer;
    protected final JoinColumn.ParentAdapter joinColumnParentAdapter = this.buildJoinColumnParentAdapter();
    protected OrmSpecifiedJoinColumn defaultJoinColumn;

    protected AbstractOrmJoinColumnRelationshipStrategy(P parent) {
        super(parent);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    protected XmlJoinColumnContainer getXmlJoinColumnContainer() {
        return this.getRelationship().getXmlContainer();
    }

    @Override
    public ListIterable<OrmSpecifiedJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public ListIterable<OrmSpecifiedJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer;
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public OrmSpecifiedJoinColumn getSpecifiedJoinColumn(int index) {
        return (OrmSpecifiedJoinColumn)this.specifiedJoinColumnContainer.get(index);
    }

    @Override
    public OrmSpecifiedJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.getSpecifiedJoinColumnsSize());
    }

    @Override
    public OrmSpecifiedJoinColumn addSpecifiedJoinColumn(int index) {
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmSpecifiedJoinColumn joinColumn = (OrmSpecifiedJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, xmlJoinColumn);
        this.getXmlJoinColumnContainer().getJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    protected XmlJoinColumn buildXmlJoinColumn() {
        return OrmFactory.eINSTANCE.createXmlJoinColumn();
    }

    @Override
    public void removeSpecifiedJoinColumn(SpecifiedJoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumnContainer.indexOf((OrmSpecifiedJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        this.specifiedJoinColumnContainer.remove(index);
        this.getXmlJoinColumnContainer().getJoinColumns().remove(index);
    }

    @Override
    public void convertDefaultJoinColumnsToSpecified() {
        if (this.defaultJoinColumn == null) {
            throw new IllegalStateException("default  join column is null");
        }
        String columnName = this.defaultJoinColumn.getDefaultName();
        String referencedColumnName = this.defaultJoinColumn.getDefaultReferencedColumnName();
        OrmSpecifiedJoinColumn joinColumn = this.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName(columnName);
        joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
    }

    @Override
    public void clearSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.clear();
        this.getXmlJoinColumnContainer().getJoinColumns().clear();
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.specifiedJoinColumnContainer.move(targetIndex, sourceIndex);
        this.getXmlJoinColumnContainer().getJoinColumns().move(targetIndex, sourceIndex);
    }

    protected void syncSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJoinColumn> getXmlJoinColumns() {
        return IterableTools.cloneLive(this.getXmlJoinColumnContainer().getJoinColumns());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSpecifiedJoinColumn, XmlJoinColumn> buildSpecifiedJoinColumnContainer() {
        return this.buildSpecifiedContextListContainer("specifiedJoinColumns", new SpecifiedJoinColumnContainerAdapter());
    }

    protected abstract JoinColumn.ParentAdapter buildJoinColumnParentAdapter();

    @Override
    public OrmSpecifiedJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmSpecifiedJoinColumn joinColumn) {
        OrmSpecifiedJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmSpecifiedJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns() && this.getRelationship().mayHaveDefaultJoinColumn();
    }

    @Override
    public OrmJoinColumnRelationship getRelationship() {
        return (OrmJoinColumnRelationship)this.parent;
    }

    protected OrmSpecifiedJoinColumn buildJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextModelFactory().buildOrmJoinColumn(this.joinColumnParentAdapter, xmlJoinColumn);
    }

    @Override
    public void initializeFrom(OrmSpecifiedJoinColumnRelationshipStrategy oldStrategy) {
        for (OrmSpecifiedJoinColumn joinColumn : oldStrategy.getSpecifiedJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFrom(VirtualJoinColumnRelationshipStrategy virtualStrategy) {
        for (VirtualJoinColumn joinColumn : virtualStrategy.getJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public String getTableName() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null && typeMapping.tableNameIsInvalid(tableName);
    }

    public Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    protected Iterable<String> getCandidateTableNames() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null ? typeMapping.getAllAssociatedTableNames() : EmptyIterable.instance();
    }

    @Override
    public void addStrategy() {
        if (this.getSpecifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn();
        }
    }

    @Override
    public void removeStrategy() {
        int i = this.getSpecifiedJoinColumnsSize();
        while (i-- > 0) {
            this.removeSpecifiedJoinColumn(i);
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (OrmSpecifiedJoinColumn joinColumn : this.getJoinColumns()) {
            joinColumn.validate(messages, reporter);
        }
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmSpecifiedJoinColumn joinColumn : this.getJoinColumns()) {
            result = joinColumn.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSpecifiedJoinColumn, XmlJoinColumn> {
        @Override
        public OrmSpecifiedJoinColumn buildContextElement(XmlJoinColumn resourceElement) {
            return AbstractOrmJoinColumnRelationshipStrategy.this.buildJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<XmlJoinColumn> getResourceElements() {
            return AbstractOrmJoinColumnRelationshipStrategy.this.getXmlJoinColumns();
        }

        @Override
        public XmlJoinColumn extractResourceElement(OrmSpecifiedJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }
    }
}

