/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAccessHolder;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmPersistentAttribute
extends AbstractOrmXmlContextModel<OrmPersistentType>
implements OrmSpecifiedPersistentAttribute,
SpecifiedPersistentAttribute2_0 {
    protected OrmAttributeMapping mapping;
    protected JavaSpecifiedPersistentAttribute javaPersistentAttribute;
    protected JavaSpecifiedPersistentAttribute cachedJavaPersistentAttribute;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;

    protected AbstractOrmPersistentAttribute(OrmPersistentType parent, XmlAttributeMapping xmlMapping) {
        super(parent);
        this.mapping = this.buildMapping(xmlMapping);
        this.specifiedAccess = this.buildSpecifiedAccess();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.mapping.synchronizeWithResourceModel();
        if (this.cachedJavaPersistentAttribute != null) {
            this.cachedJavaPersistentAttribute.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.setJavaPersistentAttribute(this.buildJavaPersistentAttribute());
        this.mapping.update();
        if (this.cachedJavaPersistentAttribute != null) {
            this.cachedJavaPersistentAttribute.update();
        }
    }

    @Override
    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OrmAttributeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public OrmAttributeMapping setMappingKey(String mappingKey) {
        if (ObjectTools.notEquals((Object)this.getMappingKey(), (Object)mappingKey)) {
            this.setMappingKey_(mappingKey);
        }
        return this.mapping;
    }

    protected void setMappingKey_(String mappingKey) {
        OrmAttributeMappingDefinition mappingDefinition = this.getMappingFileDefinition().getAttributeMappingDefinition(mappingKey);
        XmlAttributeMapping xmlAttributeMapping = mappingDefinition.buildResourceMapping(this.getResourceModelFactory());
        this.setMapping(this.buildMapping(xmlAttributeMapping));
    }

    protected final OrmAttributeMapping buildMapping(XmlAttributeMapping xmlAttributeMapping) {
        OrmAttributeMappingDefinition md = this.getMappingFileDefinition().getAttributeMappingDefinition(xmlAttributeMapping.getMappingKey());
        return md.buildContextMapping(this, xmlAttributeMapping, this.getContextModelFactory());
    }

    protected void setMapping(OrmAttributeMapping mapping) {
        OrmAttributeMapping old = this.mapping;
        this.mapping = mapping;
        this.getDeclaringPersistentType().changeMapping(this, old, mapping);
        this.firePropertyChanged("mapping", old, mapping);
        old.initializeOn(mapping);
    }

    @Override
    public String getDefaultMappingKey() {
        return null;
    }

    protected XmlAttributeMapping getXmlAttributeMapping() {
        return this.mapping.getXmlAttributeMapping();
    }

    @Override
    public String getName() {
        return this.mapping.getName();
    }

    @Override
    public void nameChanged(String oldName, String newName) {
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public JavaSpecifiedPersistentAttribute getJavaPersistentAttribute() {
        return this.javaPersistentAttribute;
    }

    @Override
    public JavaSpecifiedPersistentAttribute resolveJavaPersistentAttribute() {
        return this.javaPersistentAttribute;
    }

    @Override
    public JavaResourceAttribute getJavaResourceAttribute() {
        return this.javaPersistentAttribute == null ? null : this.javaPersistentAttribute.getResourceAttribute();
    }

    @Override
    public boolean isFor(JavaResourceField javaResourceField) {
        return this.javaPersistentAttribute != null && this.javaPersistentAttribute.isFor(javaResourceField);
    }

    @Override
    public boolean isFor(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter) {
        return this.javaPersistentAttribute != null && this.javaPersistentAttribute.isFor(javaResourceGetter, javaResourceSetter);
    }

    protected void setJavaPersistentAttribute(JavaSpecifiedPersistentAttribute javaPersistentAttribute) {
        JavaSpecifiedPersistentAttribute old = this.javaPersistentAttribute;
        this.javaPersistentAttribute = javaPersistentAttribute;
        this.firePropertyChanged("javaPersistentAttribute", old, javaPersistentAttribute);
    }

    protected JavaSpecifiedPersistentAttribute buildJavaPersistentAttribute() {
        JavaSpecifiedPersistentAttribute javaAttribute;
        String name = this.getName();
        if (name == null) {
            return null;
        }
        JavaPersistentType javaType = this.getDeclaringPersistentTypeJavaType();
        if (javaType == null) {
            return null;
        }
        PersistentAttribute pAttribute = javaType.resolveAttribute(name);
        JavaSpecifiedPersistentAttribute javaSpecifiedPersistentAttribute = javaAttribute = pAttribute == null ? null : pAttribute.getJavaPersistentAttribute();
        if (javaAttribute != null && javaAttribute.getAccess() == this.getAccess()) {
            this.cachedJavaPersistentAttribute = null;
            return javaAttribute;
        }
        return this.getCachedJavaAttribute();
    }

    protected JavaSpecifiedPersistentAttribute getCachedJavaAttribute() {
        JavaResourceType javaResourceType = this.getDeclaringPersistentTypeJavaType().getJavaResourceType();
        if (javaResourceType == null) {
            return null;
        }
        if (this.getAccess() == AccessType.FIELD) {
            JavaResourceField javaResourceField = this.getJavaResourceField(javaResourceType);
            if (javaResourceField == null) {
                this.cachedJavaPersistentAttribute = null;
            } else if (this.cachedJavaPersistentAttribute == null || !this.cachedJavaPersistentAttribute.isFor(javaResourceField)) {
                this.cachedJavaPersistentAttribute = this.buildJavaPersistentField(javaResourceField);
            }
        } else if (this.getAccess() == AccessType.PROPERTY) {
            JavaResourceMethod javaResourceSetter;
            JavaResourceMethod javaResourceGetter = this.getJavaResourceGetter(javaResourceType);
            JavaResourceMethod javaResourceMethod = javaResourceSetter = javaResourceGetter == null ? null : (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)javaResourceGetter);
            if (javaResourceGetter == null && javaResourceSetter == null) {
                this.cachedJavaPersistentAttribute = null;
            } else if (this.cachedJavaPersistentAttribute == null || !this.cachedJavaPersistentAttribute.isFor(javaResourceGetter, javaResourceSetter)) {
                this.cachedJavaPersistentAttribute = this.buildJavaPersistentProperty(javaResourceGetter, javaResourceSetter);
            }
        }
        return this.cachedJavaPersistentAttribute;
    }

    protected JavaResourceField getJavaResourceField(JavaResourceType javaResourceType) {
        if (javaResourceType == null) {
            return null;
        }
        for (JavaResourceField javaResourceField : this.getJavaResourceFields(javaResourceType)) {
            if (!javaResourceField.getName().equals(this.getName())) continue;
            return javaResourceField;
        }
        String superclassName = javaResourceType.getSuperclassQualifiedName();
        if (superclassName == null) {
            return null;
        }
        JavaResourceType superclass = (JavaResourceType)this.getJpaProject().getJavaResourceType(superclassName, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        if (superclass == null) {
            return null;
        }
        return this.getJavaResourceField(superclass);
    }

    protected Iterable<JavaResourceField> getJavaResourceFields(JavaResourceType javaResourceType) {
        return javaResourceType.getFields();
    }

    protected JavaResourceMethod getJavaResourceGetter(JavaResourceType javaResourceType) {
        for (JavaResourceMethod javaResourceGetter : this.getJavaResourceGetters(javaResourceType)) {
            if (!javaResourceGetter.getName().equals(this.getName())) continue;
            return javaResourceGetter;
        }
        String superclassName = javaResourceType.getSuperclassQualifiedName();
        if (superclassName == null) {
            return null;
        }
        JavaResourceType superclass = (JavaResourceType)this.getJpaProject().getJavaResourceType(superclassName, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        if (superclass == null) {
            return null;
        }
        return this.getJavaResourceGetter(superclass);
    }

    protected Iterable<JavaResourceMethod> getJavaResourceGetters(JavaResourceType javaResourceType) {
        return this.filterJavaResourceMethods(javaResourceType, (Predicate<JavaResourceMethod>)JavaResourceMethod.IS_PROPERTY_GETTER);
    }

    protected Iterable<JavaResourceMethod> filterJavaResourceMethods(JavaResourceType javaResourceType, Predicate<JavaResourceMethod> predicate) {
        return IterableTools.filter((Iterable)javaResourceType.getMethods(), predicate);
    }

    protected JavaSpecifiedPersistentAttribute buildJavaPersistentField(JavaResourceField javaResourceField) {
        return this.getJpaFactory().buildJavaPersistentField(this.getDeclaringPersistentType(), javaResourceField);
    }

    protected JavaSpecifiedPersistentAttribute buildJavaPersistentProperty(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter) {
        return this.getJpaFactory().buildJavaPersistentProperty(this.getDeclaringPersistentType(), javaResourceGetter, javaResourceSetter);
    }

    @Override
    public AccessType getAccess() {
        AccessType access = this.getSpecifiedAccess();
        return access != null ? access : this.defaultAccess;
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType oldAccess = this.getAccess();
        AccessType oldDefaultAccess = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", oldDefaultAccess, access);
        if (oldAccess != this.getAccess() && this.cachedJavaPersistentAttribute != null) {
            this.setJavaPersistentAttribute(null);
            this.cachedJavaPersistentAttribute = null;
        }
    }

    protected AccessType buildDefaultAccess() {
        return this.getDeclaringPersistentType().getAccess();
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        this.setSpecifiedAccess_(access);
        this.getXmlAccessHolder().setAccess(AccessType.toOrmResourceModel(access));
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType oldAccess = this.getAccess();
        AccessType oldSpecifiedAccess = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", oldSpecifiedAccess, access);
        if (oldAccess != this.getAccess() && this.cachedJavaPersistentAttribute != null) {
            this.setJavaPersistentAttribute(null);
            this.cachedJavaPersistentAttribute = null;
        }
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromOrmResourceModel(this.getXmlAccessHolder().getAccess(), this.getJpaPlatform(), this.getResourceType());
    }

    protected XmlAccessHolder getXmlAccessHolder() {
        return this.getXmlAttributeMapping();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public OrmPersistentAttribute removeFromXml() {
        return this.getDeclaringPersistentType().removeAttributeFromXml(this);
    }

    @Override
    public OrmSpecifiedPersistentAttribute addToXml() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OrmSpecifiedPersistentAttribute addToXml(String mappingKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    @Override
    public Class<OrmPersistentAttribute> getStructureType() {
        return OrmPersistentAttribute.class;
    }

    public Iterable<JpaStructureNode> getStructureChildren() {
        return IterableTools.emptyIterable();
    }

    @Override
    public int getStructureChildrenSize() {
        return 0;
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        return this;
    }

    @Override
    public TextRange getFullTextRange() {
        return this.getXmlAttributeMapping().getFullTextRange();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.getXmlAttributeMapping().containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.mapping.getSelectionTextRange();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.mapping.createRenameTypeEdits(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.mapping.createMoveTypeEdits(originalType, newPackage);
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.mapping.createRenamePackageEdits(originalPackage, newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttribute(messages, reporter);
        this.mapping.validate(messages, reporter);
    }

    protected void validateAttribute(List<IMessage> messages, IReporter reporter) {
        if (this.javaPersistentAttribute == null) {
            this.validateUnresolvedAttribute(messages);
        } else {
            this.buildAttibuteValidator().validate(messages, reporter);
        }
    }

    protected void validateUnresolvedAttribute(List<IMessage> messages) {
        String name = this.getName();
        if (StringTools.isBlank((String)name)) {
            return;
        }
        JavaPersistentType javaType = this.getDeclaringPersistentTypeJavaType();
        if (javaType == null) {
            return;
        }
        messages.add(this.buildValidationMessage((JpaModel)this.mapping, this.mapping.getNameTextRange(), JptJpaCoreValidationMessages.PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME, name, javaType.getName()));
    }

    protected abstract JpaValidator buildAttibuteValidator();

    @Override
    public TextRange getValidationTextRange() {
        return this.mapping.getValidationTextRange();
    }

    @Override
    public String getMetamodelContainerFieldTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelContainerFieldMapKeyTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldMapKeyTypeName((CollectionMapping)((Object)this.mapping));
    }

    @Override
    public String getMetamodelTypeName() {
        SpecifiedPersistentAttribute2_0 javaAttribute = (SpecifiedPersistentAttribute2_0)((Object)this.javaPersistentAttribute);
        return javaAttribute != null ? javaAttribute.getMetamodelTypeName() : MetamodelField2_0.DEFAULT_TYPE_NAME;
    }

    protected JavaSpecifiedPersistentAttribute.JpaContainerDefinition getJpaContainerDefinition() {
        return this.javaPersistentAttribute != null ? this.javaPersistentAttribute.getJpaContainerDefinition() : JavaSpecifiedPersistentAttribute.JpaContainerDefinition.Null.instance();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.mapping.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public OrmPersistentType getDeclaringPersistentType() {
        return (OrmPersistentType)this.parent;
    }

    protected JavaPersistentType getDeclaringPersistentTypeJavaType() {
        return this.getDeclaringPersistentType().getJavaPersistentType();
    }

    @Override
    public OrmTypeMapping getDeclaringTypeMapping() {
        return this.getDeclaringPersistentType().getMapping();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.mapping.getPrimaryKeyColumnName();
    }

    @Override
    public String getTypeName() {
        return this.mapping.getFullyQualifiedAttributeType();
    }

    @Override
    public String getTypeName(PersistentType contextType) {
        while (contextType != null) {
            if (contextType == this.getDeclaringPersistentType()) {
                return this.getTypeName();
            }
            TypeBinding typeBinding = contextType.getAttributeTypeBinding(this);
            if (typeBinding != null) {
                return typeBinding.getQualifiedName();
            }
            contextType = contextType.getSuperPersistentType();
        }
        return null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

