/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullAttributeOverrideColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;

public final class BinaryAttributeOverrideAnnotation
extends BinaryOverrideAnnotation
implements AttributeOverrideAnnotation {
    private ColumnAnnotation column = this.buildColumn();
    private final ColumnAnnotation nullColumn = this.buildNullColumn();

    public BinaryAttributeOverrideAnnotation(JavaResourceModel parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    public String getAnnotationName() {
        return "javax.persistence.AttributeOverride";
    }

    public void update() {
        super.update();
        this.updateColumn();
    }

    protected String getNameElementName() {
        return "name";
    }

    public ColumnAnnotation getColumn() {
        return this.column;
    }

    public ColumnAnnotation getNonNullColumn() {
        return this.column != null ? this.column : this.nullColumn;
    }

    public ColumnAnnotation addColumn() {
        throw new UnsupportedOperationException();
    }

    public void removeColumn() {
        throw new UnsupportedOperationException();
    }

    private ColumnAnnotation buildColumn() {
        IAnnotation jdtColumn = this.getJdtColumn();
        return jdtColumn == null ? null : this.buildColumn(jdtColumn);
    }

    private ColumnAnnotation buildNullColumn() {
        return new NullAttributeOverrideColumnAnnotation(this);
    }

    private ColumnAnnotation buildColumn(IAnnotation jdtColumn) {
        return new BinaryColumnAnnotation((JavaResourceModel)this, jdtColumn);
    }

    private IAnnotation getJdtColumn() {
        return (IAnnotation)this.getJdtMemberValue("column");
    }

    private void setColumn(ColumnAnnotation column) {
        ColumnAnnotation old = this.column;
        this.column = column;
        this.firePropertyChanged("column", old, column);
    }

    private void updateColumn() {
        throw new UnsupportedOperationException();
    }
}

