/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceBaseColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.CompleteColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceCompleteColumnAnnotation
extends SourceBaseColumnAnnotation
implements CompleteColumnAnnotation {
    protected DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter = this.buildLengthDeclarationAdapter();
    protected AnnotationElementAdapter<Integer> lengthAdapter = this.buildLengthAdapter();
    protected Integer length;
    protected TextRange lengthTextRange;
    protected DeclarationAnnotationElementAdapter<Integer> precisionDeclarationAdapter = this.buildPrecisionDeclarationAdapter();
    protected AnnotationElementAdapter<Integer> precisionAdapter = this.buildPrecisionAdapter();
    protected Integer precision;
    protected TextRange precisionTextRange;
    protected DeclarationAnnotationElementAdapter<Integer> scaleDeclarationAdapter = this.buildScaleDeclarationAdapter();
    protected AnnotationElementAdapter<Integer> scaleAdapter = this.buildScaleAdapter();
    protected Integer scale;
    protected TextRange scaleTextRange;

    protected SourceCompleteColumnAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super(parent, element, daa);
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.length = this.buildLength(astAnnotation);
        this.lengthTextRange = this.buildLengthTextRange(astAnnotation);
        this.precision = this.buildPrecision(astAnnotation);
        this.precisionTextRange = this.buildPrecisionTextRange(astAnnotation);
        this.scale = this.buildScale(astAnnotation);
        this.scaleTextRange = this.buildScaleTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncLength(this.buildLength(astAnnotation));
        this.lengthTextRange = this.buildLengthTextRange(astAnnotation);
        this.syncPrecision(this.buildPrecision(astAnnotation));
        this.precisionTextRange = this.buildPrecisionTextRange(astAnnotation);
        this.syncScale(this.buildScale(astAnnotation));
        this.scaleTextRange = this.buildScaleTextRange(astAnnotation);
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        if (ObjectTools.notEquals((Object)this.length, (Object)length)) {
            this.length = length;
            this.lengthAdapter.setValue((Object)length);
        }
    }

    private void syncLength(Integer astLength) {
        Integer old = this.length;
        this.length = astLength;
        this.firePropertyChanged("length", old, astLength);
    }

    private Integer buildLength(Annotation astAnnotation) {
        return (Integer)this.lengthAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getLengthTextRange() {
        return this.lengthTextRange;
    }

    protected TextRange buildLengthTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.lengthDeclarationAdapter, astAnnotation);
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildLengthDeclarationAdapter() {
        return this.buildIntegerElementAdapter(this.getLengthElementName());
    }

    protected AnnotationElementAdapter<Integer> buildLengthAdapter() {
        return this.buildIntegerElementAdapter(this.lengthDeclarationAdapter);
    }

    protected abstract String getLengthElementName();

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Integer precision) {
        if (ObjectTools.notEquals((Object)this.precision, (Object)precision)) {
            this.precision = precision;
            this.precisionAdapter.setValue((Object)precision);
        }
    }

    private void syncPrecision(Integer astPrecision) {
        Integer old = this.precision;
        this.precision = astPrecision;
        this.firePropertyChanged("precision", old, astPrecision);
    }

    private Integer buildPrecision(Annotation astAnnotation) {
        return (Integer)this.precisionAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getPrecisionTextRange() {
        return this.precisionTextRange;
    }

    protected TextRange buildPrecisionTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.precisionDeclarationAdapter, astAnnotation);
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildPrecisionDeclarationAdapter() {
        return this.buildIntegerElementAdapter(this.getPrecisionElementName());
    }

    protected AnnotationElementAdapter<Integer> buildPrecisionAdapter() {
        return this.buildIntegerElementAdapter(this.precisionDeclarationAdapter);
    }

    protected abstract String getPrecisionElementName();

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setScale(Integer scale) {
        if (ObjectTools.notEquals((Object)this.scale, (Object)scale)) {
            this.scale = scale;
            this.scaleAdapter.setValue((Object)scale);
        }
    }

    private void syncScale(Integer astScale) {
        Integer old = this.scale;
        this.scale = astScale;
        this.firePropertyChanged("scale", old, astScale);
    }

    private Integer buildScale(Annotation astAnnotation) {
        return (Integer)this.scaleAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getScaleTextRange() {
        return this.scaleTextRange;
    }

    protected TextRange buildScaleTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.scaleDeclarationAdapter, astAnnotation);
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildScaleDeclarationAdapter() {
        return this.buildIntegerElementAdapter(this.getScaleElementName());
    }

    protected AnnotationElementAdapter<Integer> buildScaleAdapter() {
        return this.buildIntegerElementAdapter(this.scaleDeclarationAdapter);
    }

    protected abstract String getScaleElementName();

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.length == null && this.precision == null && this.scale == null;
    }
}

