/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.List;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceQueryAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceQueryHintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceNamedQueryAnnotation
extends SourceQueryAnnotation
implements NamedQueryAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.NamedQuery");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.NamedQueries");
    DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter = this.buildQueryDeclarationAdapter();
    AnnotationElementAdapter<String> queryAdapter = this.buildQueryAdapter();
    String query;
    List<TextRange> queryTextRanges;

    protected SourceNamedQueryAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    public String getAnnotationName() {
        return "javax.persistence.NamedQuery";
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.query = this.buildQuery(astAnnotation);
        this.queryTextRanges = this.buildQueryTextRanges(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncQuery(this.buildQuery(astAnnotation));
        this.queryTextRanges = this.buildQueryTextRanges(astAnnotation);
    }

    @Override
    public String getNameElementName() {
        return "name";
    }

    String getQueryElementName() {
        return "query";
    }

    @Override
    public String getHintsElementName() {
        return "hints";
    }

    @Override
    public QueryHintAnnotation buildHint(int index) {
        return SourceQueryHintAnnotation.buildNamedQueryQueryHint((JavaResourceModel)this, this.annotatedElement, this.daa, index);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        if (ObjectTools.notEquals((Object)this.query, (Object)query)) {
            this.query = query;
            this.queryAdapter.setValue((Object)query);
        }
    }

    private void syncQuery(String annotationQuery) {
        String old = this.query;
        this.query = annotationQuery;
        this.firePropertyChanged("query", old, annotationQuery);
    }

    private String buildQuery(Annotation astAnnotation) {
        return (String)this.queryAdapter.getValue(astAnnotation);
    }

    @Override
    public List<TextRange> getQueryTextRanges() {
        return this.queryTextRanges;
    }

    private List<TextRange> buildQueryTextRanges(Annotation astAnnotation) {
        return this.getElementTextRanges(this.queryDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildQueryDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)this.getQueryElementName());
    }

    private AnnotationElementAdapter<String> buildQueryAdapter() {
        return this.buildStringElementAdapter(this.queryDeclarationAdapter);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.query == null;
    }

    protected static IndexedAnnotationAdapter buildNamedQueryAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    protected static IndexedDeclarationAnnotationAdapter buildNamedQueryDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "javax.persistence.NamedQuery");
        return idaa;
    }
}

