/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.OrderBySpecification;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.Modifier;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect.OrderByTableElement;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.SelectGridViewer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;

public class FullSelectOrderViewer
extends NavigableTableViewer
implements IMenuListener {
    protected SQLDomainModel domainModel;
    protected Table table;
    protected TableColumn c1;
    protected TableColumn c2;
    protected TableColumn c3;
    protected FullSelectOrderLabelProvider fullSelectOrderProvider;
    protected OrderContentProvider orderContentProvider;
    ComboBoxCellEditor columnCellEditor;
    SortOrderComboBoxCellEditor sortOrderCellEditor;

    public FullSelectOrderViewer(SQLDomainModel domainModel, Composite parent) {
        super(new Table(parent, 65538));
        this.domainModel = domainModel;
        this.table = this.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)ViewUtility.createFill());
        WorkbenchHelp.setHelp((Control)this.table, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqdf0020");
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.table.setLayout((Layout)layout);
        this.c1 = new TableColumn(this.table, 0);
        this.c1.setText(Messages._UI_COLUMN_DEFAULT_COLUMN);
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_SELECT_SORT_TYPE);
        this.c3 = new TableColumn(this.table, 0);
        this.c3.setText(Messages._UI_COLUMN_SELECT_SORT_ORDER);
        String[] columnProperties = new String[]{(String)SQLBuilderConstants.P_STATEMENT_COLUMN, (String)SQLBuilderConstants.P_STATEMENT_SORTTYPE, (String)SQLBuilderConstants.P_STATEMENT_SORTORDER};
        this.setColumnProperties(columnProperties);
        this.columnCellEditor = new ColumnNameComboBoxCellEditor((Composite)this.table);
        this.sortOrderCellEditor = new SortOrderComboBoxCellEditor((Composite)this.table);
        CellEditor[] editors = new CellEditor[]{this.columnCellEditor, new SortTypeComboBoxCellEditor((Composite)this.table), this.sortOrderCellEditor};
        this.setCellEditors(editors);
        this.setCellModifier(new Modifier());
        this.orderContentProvider = new OrderContentProvider(domainModel.getAdapterFactory());
        this.setContentProvider((IContentProvider)this.orderContentProvider);
        this.fullSelectOrderProvider = new FullSelectOrderLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)this.fullSelectOrderProvider);
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager menu) {
        RemoveOrderByAction removeOrderByAction = new RemoveOrderByAction(this);
        menu.add((IAction)removeOrderByAction);
    }

    protected void inputChanged(Object input, Object oldInput) {
        QueryCombined queryCombined;
        QueryStatement stmt;
        if (input instanceof QueryCombined && (stmt = StatementHelper.getQueryStatementForTableReference((TableReference)(queryCombined = (QueryCombined)input))) instanceof QuerySelectStatement) {
            QuerySelectStatement selectStmt = (QuerySelectStatement)stmt;
            this.refreshColumnCombo(selectStmt);
            super.inputChanged(input, oldInput);
            this.createSortOrderCombo(selectStmt);
        }
    }

    @Override
    public void refresh() {
        QueryCombined queryCombined;
        QueryStatement stmt;
        super.refresh();
        Object input = this.getInput();
        if (input instanceof QueryCombined && (stmt = StatementHelper.getQueryStatementForTableReference((TableReference)(queryCombined = (QueryCombined)input))) instanceof QuerySelectStatement) {
            this.createSortOrderCombo((QuerySelectStatement)stmt);
        }
    }

    protected void refreshColumnCombo(QuerySelectStatement fullSelect) {
        ArrayList<LabelValuePair> items = new ArrayList<LabelValuePair>();
        List columns = BuilderUtility.getColumnVector((SQLQueryObject)fullSelect);
        for (QueryValueExpression expr : columns) {
            items.add(new LabelValuePair(expr.getSQL(), expr));
        }
        items.add(new LabelValuePair(" ", " "));
        int size = items.size();
        LabelValuePair[] pairArray = new LabelValuePair[size];
        int i = 0;
        while (i < size) {
            pairArray[i] = (LabelValuePair)items.get(i);
            ++i;
        }
        this.columnCellEditor.createItems(pairArray);
        this.createSortOrderCombo(fullSelect);
    }

    private void createSortOrderCombo(QuerySelectStatement fullSelect) {
        int totalColumn = 0;
        EList orderByList = fullSelect.getOrderByClause();
        if (orderByList != null) {
            totalColumn = orderByList.size();
        }
        if (totalColumn > 0) {
            LabelValuePair[] sortOrderItems = new LabelValuePair[totalColumn];
            int i = 0;
            while (i < totalColumn) {
                String item = new Integer(i + 1).toString();
                sortOrderItems[i] = new LabelValuePair(item, item);
                ++i;
            }
            this.sortOrderCellEditor.createItems(sortOrderItems);
        } else {
            this.sortOrderCellEditor.createItems(null);
        }
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this.table.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            Composite control = this.table.getParent();
            this.table.setBackground(control.getBackground());
        }
    }

    class ColumnNameComboBoxCellEditor
    extends ComboBoxCellEditor {
        public ColumnNameComboBoxCellEditor(Composite parent) {
            super(parent, null);
        }

        @Override
        protected void doSetValue(Object value) {
            super.doSetValue(value);
        }
    }

    class FullSelectOrderLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        FullSelectOrderLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof OrderByTableElement) {
                OrderByTableElement element = (OrderByTableElement)object;
                return element.getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }

    public class OrderContentProvider
    extends GridContentProvider {
        public OrderContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object property) {
            this.adapterFactory.adapt(property, IStructuredItemContentProvider.class);
            this.tableElements = new Vector();
            if (property instanceof QueryCombined) {
                EList orderByList;
                QueryCombined queryCombined = (QueryCombined)property;
                QueryStatement stmt = StatementHelper.getQueryStatementForTableReference((TableReference)queryCombined);
                QuerySelectStatement fullSelect = null;
                if (stmt instanceof QuerySelectStatement && (orderByList = (fullSelect = (QuerySelectStatement)stmt).getOrderByClause()) != null) {
                    for (OrderBySpecification obs : orderByList) {
                        this.createNewOrderByElement(fullSelect, obs);
                    }
                }
                this.createNewOrderByElement(fullSelect, null);
            }
            return this.tableElements.toArray();
        }

        private void createNewOrderByElement(QuerySelectStatement fullSelect, OrderBySpecification expr) {
            this.tableElements.add(new OrderByTableElement(fullSelect, expr));
        }
    }

    class RemoveOrderByAction
    extends Action {
        TableViewer gridViewer;

        public RemoveOrderByAction(TableViewer gridViewer) {
            super(Messages._UI_ACTION_REMOVE);
            this.gridViewer = gridViewer;
        }

        public void run() {
            ISelection selection = this.gridViewer.getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection es = (IStructuredSelection)selection;
            Iterator elements = es.iterator();
            this.gridViewer.cancelEditing();
            while (elements.hasNext()) {
                Object item = elements.next();
                if (!(item instanceof OrderByTableElement)) continue;
                OrderByTableElement tableElement = (OrderByTableElement)item;
                QuerySelectStatement fullSelectStmt = tableElement.getFullSelectStatement();
                OrderBySpecification spec = tableElement.getOrderBy();
                fullSelectStmt.getOrderByClause().remove((Object)spec);
            }
        }
    }

    class SortOrderComboBoxCellEditor
    extends ComboBoxCellEditor {
        public SortOrderComboBoxCellEditor(Composite parent) {
            super(parent, null);
        }

        @Override
        protected void doSetValue(Object value) {
            super.doSetValue(value);
        }
    }

    class SortTypeComboBoxCellEditor
    extends ComboBoxCellEditor {
        public SortTypeComboBoxCellEditor(Composite parent) {
            super(parent, new LabelValuePair[3]);
            LabelValuePair[] items = this.getLabelValuePairs();
            items[0] = new LabelValuePair(SelectGridViewer.P_ASCENDING, SelectGridViewer.P_ASCENDING);
            items[1] = new LabelValuePair(SelectGridViewer.P_DESCENDING, SelectGridViewer.P_DESCENDING);
            items[2] = new LabelValuePair(SelectGridViewer.P_DEFAULT, SelectGridViewer.P_DEFAULT);
        }
    }
}

