/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.internal.plugin.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IProjectValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbValidator
extends AbstractValidator
implements IValidator {
    private static final String OLD_RELATIVE_MARKER_TYPE = "jaxbProblemMarker";
    private static final String OLD_MARKER_TYPE = String.valueOf(JaxbProject.MARKER_TYPE_SCOPE_) + "jaxbProblemMarker";
    private static final Predicate<IMessage> MESSAGE_IS_NOT_IGNORED = new MessageIsNotIgnored();

    public void validate(IValidationContext context, IReporter reporter) {
        this.validate(reporter, ((IProjectValidationContext)context).getProject());
    }

    public void cleanup(IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        IProject project = resource.getProject();
        result.setSuspendValidation(project);
        this.validate(reporter, project);
        return result;
    }

    private void validate(IReporter reporter, IProject project) {
        Iterable<IMessage> messages = this.buildNonIgnoredValidationMessages(reporter, project);
        this.clearMarkers(project);
        for (IMessage message : messages) {
            reporter.addMessage((IValidator)this, message);
        }
    }

    private Iterable<IMessage> buildNonIgnoredValidationMessages(IReporter reporter, IProject project) {
        return IterableTools.filter(this.buildValidationMessages(reporter, project), MESSAGE_IS_NOT_IGNORED);
    }

    private Iterable<IMessage> buildValidationMessages(IReporter reporter, IProject project) {
        JaxbProject jaxbProject = this.getJaxbProject(project);
        return jaxbProject != null ? jaxbProject.getValidationMessages(reporter) : this.buildValidationFailedMessages(project);
    }

    private JaxbProject getJaxbProject(IProject project) {
        JaxbProjectManager jaxbProjectManager = this.getJaxbProjectManager();
        return jaxbProjectManager == null ? null : jaxbProjectManager.getJaxbProject(project);
    }

    private JaxbProjectManager getJaxbProjectManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : this.getJaxbWorkspace().getJaxbProjectManager();
    }

    private JaxbWorkspace getJaxbWorkspace() {
        return (JaxbWorkspace)ResourcesPlugin.getWorkspace().getAdapter(JaxbWorkspace.class);
    }

    private Iterable<IMessage> buildValidationFailedMessages(IProject project) {
        return IterableTools.singletonIterable((Object)this.buildValidationFailedMessage(project));
    }

    private IMessage buildValidationFailedMessage(IProject project) {
        return ValidationMessageTools.buildValidationMessage((IResource)project, (ValidationMessage)JptJaxbCoreValidationMessages.JAXB_VALIDATION_FAILED);
    }

    private void clearMarkers(IProject project) {
        try {
            this.clearMarkers_(project);
        }
        catch (CoreException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
        }
    }

    private void clearMarkers_(IProject project) throws CoreException {
        Object[] markers = project.findMarkers(JaxbProject.MARKER_TYPE, true, 2);
        ArrayTools.addAll((Object[])markers, (Object[])project.findMarkers(OLD_MARKER_TYPE, true, 2));
        Object[] objectArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            Object marker = objectArray[n2];
            marker.delete();
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageIsNotIgnored
    extends PredicateAdapter<IMessage> {
        MessageIsNotIgnored() {
        }

        public boolean evaluate(IMessage message) {
            return message.getSeverity() != -1;
        }
    }
}

