/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepositoryConstants;
import org.eclipse.datatools.connectivity.ui.IConnectionProfileActionFilter;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConnectionProfileActionFilter
extends PropertyTester
implements IConnectionProfileActionFilter,
IPropertyTester {
    private static boolean mDebug = ConnectivityPlugin.getDefault().isDebugging();

    public boolean testAttribute(Object target, String name, String value) {
        if (target == null || !(target instanceof IConnectionProfile)) {
            return false;
        }
        IConnectionProfile profile = (IConnectionProfile)target;
        ConnectionProfileActionFilter.debug("profile testAttribute: name =" + name + ", value = " + value);
        if (name.equals("org.eclipse.datatools.profile.property.id") || name.equals("id")) {
            return profile.getProviderId().equals(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.categoryID") || name.equals("categoryID")) {
            return profile.getCategory().getId().equals(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.hasExtendedProperties") || name.equals("hasExtendedProperties")) {
            return profile.getProvider().getProfileExtensions().size() != 0;
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.extensionID") || name.equals("extensionID")) {
            return profile.getProvider().getProfileExtensions().containsKey(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.maintainConnection") || name.equals("maintainConnection")) {
            return profile.getProvider().needsMaintainConnection();
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.isConnected") || name.equals("isConnected")) {
            return profile.getConnectionState() == 1;
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.supportsPing") || name.equals("supportsPing")) {
            return profile.getProvider().getConnectionFactories().containsKey("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.factoryID") || name.equals("factoryID")) {
            return profile.getProvider().getConnectionFactories().containsKey(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.containingViewID") || name.equals("containingViewID")) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof IViewPart) {
                IViewPart view = (IViewPart)part;
                String viewID = view.getViewSite().getId();
                return viewID.equals(value);
            }
            return false;
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.connectionState") || name.equals("connectionState")) {
            return profile.getConnectionState() == this.getConnectionStateFromString(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.dbVendor") || name.equals("dbVendor")) {
            return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.vendor").equals(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.dbVersion") || name.equals("dbVersion")) {
            return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.version").equals(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.repositoryIsReadOnly") || name.equals("repositoryIsReadOnly")) {
            IManagedConnection imc = profile.getManagedConnection(IConnectionProfileRepositoryConstants.REPOSITORY_CONNECTION_FACTORY_ID);
            if (imc != null && imc.isConnected()) {
                IConnectionProfileRepository repo = (IConnectionProfileRepository)imc.getConnection().getRawConnection();
                ConnectionProfileActionFilter.debug("org.eclipse.datatools.connectivity.profile.property.repositoryIsReadOnly, value = " + repo.isReadOnly());
                return repo.isReadOnly();
            }
            IConnectionProfileRepository repo = ((ConnectionProfile)profile).getRepository();
            if (repo != null) {
                ConnectionProfileActionFilter.debug("org.eclipse.datatools.connectivity.profile.property.repositoryIsReadOnly, value = " + repo.isReadOnly());
                return repo.isReadOnly();
            }
            ConnectionProfileActionFilter.debug("org.eclipse.datatools.connectivity.profile.property.repositoryIsReadOnly, value = false");
            return false;
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.canWorkOffline") || name.equals("canWorkOffline")) {
            return profile.supportsWorkOfflineMode();
        }
        return false;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        return this.testAttribute(receiver, property, expectedValue == null ? null : expectedValue.toString());
    }

    private int getConnectionStateFromString(String value) {
        if ("DISCONNECTED".equalsIgnoreCase(value)) {
            return 0;
        }
        if ("CONNECTED".equalsIgnoreCase(value)) {
            return 1;
        }
        if ("WORKING_OFFLINE".equalsIgnoreCase(value)) {
            return 2;
        }
        return -1;
    }

    public static void debug(String msg) {
        if (mDebug) {
            System.out.println("Debug: " + msg);
        }
    }
}

