/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.ByteArrayTools;
import org.eclipse.jpt.common.utility.internal.CharacterTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharArrayTools {
    public static final char[] CR = StringTools.CR.toCharArray();
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final char[][] EMPTY_CHAR_ARRAY_ARRAY = new char[0][0];
    public static final Transformer<char[], char[]> CAPITALIZER = new Capitalizer();
    public static final Transformer<char[], char[]> UNCAPITALIZER = new Uncapitalizer();
    public static final Predicate<char[]> IS_NOT_BLANK = new IsNotBlank();
    public static final char[] EMPTY_JAVA_STRING_LITERAL = "\"\"".toCharArray();
    public static final Transformer<char[], char[]> JAVA_STRING_LITERAL_TRANSFORMER = new JavaStringLiteralTransformer();
    public static final Transformer<char[], char[]> JAVA_STRING_LITERAL_CONTENT_TRANSFORMER = new JavaStringLiteralContentTransformer();
    public static final char[] EMPTY_DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE = "\"\"".toCharArray();
    public static final char[] EMPTY_SINGLE_QUOTED_XML_ATTRIBUTE_VALUE = "''".toCharArray();
    public static final char[] EMPTY_XML_ATTRIBUTE_VALUE = "\"\"".toCharArray();
    public static final char[] XML_ELEMENT_CDATA_START = "<![CDATA[".toCharArray();
    public static final char[] XML_ELEMENT_CDATA_END = "]]>".toCharArray();
    public static final char[] EMPTY_XML_ELEMENT_CDATA = "<![CDATA[]]>".toCharArray();
    public static final char[] XML_QUOTE = "&quot;".toCharArray();
    public static final char[] XML_AMP = "&amp;".toCharArray();
    public static final char[] XML_APOS = "&apos;".toCharArray();
    public static final char[] XML_LT = "&lt;".toCharArray();
    public static final char[] XML_GT = "&gt;".toCharArray();
    public static final Transformer<char[], char[]> XML_ATTRIBUTE_VALUE_TRANSFORMER = new XmlAttributeValueTransformer();
    public static final Transformer<char[], char[]> DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER = new DoubleQuotedXmlAttributeValueTransformer();
    public static final Transformer<char[], char[]> XML_DOUBLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER = new XmlDoubleQuotedAttributeValueContentTransformer();
    public static final Transformer<char[], char[]> SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER = new SingleQuotedXmlAttributeValueTransformer();
    public static final Transformer<char[], char[]> XML_SINGLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER = new XmlSingleQuotedAttributeValueContentTransformer();
    public static final Transformer<char[], char[]> XML_ELEMENT_TEXT_TRANSFORMER = new XmlElementTextTransformer();
    public static final Transformer<char[], char[]> XML_ELEMENT_CDATA_TRANSFORMER = new XmlElementCDATATransformer();
    public static final Transformer<char[], char[]> XML_ELEMENT_CDATA_CONTENT_TRANSFORMER = new XmlElementCDATAContentTransformer();
    public static final Comparator<char[]> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    public static char[] reverse(char[] string) {
        return string.length == 0 ? string : ArrayTools.reverse((char[])string.clone());
    }

    public static char last(char[] string) {
        return string[string.length - 1];
    }

    public static char[] concatenate(char[] ... strings) {
        int stringLength = 0;
        char[][] cArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            char[] string = cArray[n2];
            stringLength += string.length;
            ++n2;
        }
        if (stringLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] buffer = new char[stringLength];
        int i = 0;
        char[][] cArray2 = strings;
        int n3 = strings.length;
        int n4 = 0;
        while (n4 < n3) {
            char[] string = cArray2[n4];
            int len = string.length;
            if (len > 0) {
                System.arraycopy(string, 0, buffer, i, len);
                i += len;
            }
            ++n4;
        }
        return buffer;
    }

    public static char[] concatenate(Iterable<char[]> strings) {
        return CharArrayTools.concatenate(strings.iterator());
    }

    public static char[] concatenate(Iterator<char[]> strings) {
        StringBuilder sb = new StringBuilder();
        while (strings.hasNext()) {
            sb.append(strings.next());
        }
        return sb.toString().toCharArray();
    }

    public static char[] center(char[] string, int length) {
        return CharArrayTools.center(string, length, ' ');
    }

    public static char[] center(char[] string, int length, char c) {
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return ArrayTools.subArrayLength(string, stringLength - length >> 1, length);
        }
        char[] result = new char[length];
        int begin = length - stringLength >> 1;
        Arrays.fill(result, 0, begin, c);
        System.arraycopy(string, 0, result, begin, stringLength);
        Arrays.fill(result, begin + stringLength, length, c);
        return result;
    }

    public static char[] pad(char[] string, int length) {
        return CharArrayTools.pad(string, length, ' ');
    }

    public static char[] pad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return CharArrayTools.pad(string, length, c, stringLength);
    }

    public static char[] fit(char[] string, int length) {
        return CharArrayTools.fit(string, length, ' ');
    }

    public static char[] fit(char[] string, int length, char c) {
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return ArrayTools.subArrayLength(string, 0, length);
        }
        return CharArrayTools.pad(string, length, c, stringLength);
    }

    private static char[] pad(char[] string, int length, char c, int stringLength) {
        char[] result = new char[length];
        System.arraycopy(string, 0, result, 0, stringLength);
        Arrays.fill(result, stringLength, length, c);
        return result;
    }

    public static char[] zeroPad(char[] string, int length) {
        return CharArrayTools.frontPad(string, length, '0');
    }

    public static char[] frontPad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return CharArrayTools.frontPad(string, length, c, stringLength);
    }

    public static char[] zeroFit(char[] string, int length) {
        return CharArrayTools.frontFit(string, length, '0');
    }

    public static char[] frontFit(char[] string, int length, char c) {
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return ArrayTools.subArrayLength(string, stringLength - length, length);
        }
        return CharArrayTools.frontPad(string, length, c, stringLength);
    }

    private static char[] frontPad(char[] string, int length, char c, int stringLength) {
        char[] result = new char[length];
        int padLength = length - stringLength;
        System.arraycopy(string, 0, result, padLength, stringLength);
        Arrays.fill(result, 0, padLength, c);
        return result;
    }

    public static char[] repeat(char[] string, int length) {
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return ArrayTools.subArrayLength(string, 0, length);
        }
        StringBuilder sb = new StringBuilder(length);
        StringBuilderTools.repeat(sb, string, length, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] separate(char[] string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length;
        return stringLength <= segmentSize ? string : CharArrayTools.separate(string, separator, segmentSize, stringLength);
    }

    private static char[] separate(char[] string, char separator, int segmentSize, int stringLength) {
        int resultLen = stringLength + stringLength / segmentSize;
        if (stringLength % segmentSize == 0) {
            --resultLen;
        }
        char[] result = new char[resultLen];
        int j = 0;
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            if (segCount == segmentSize) {
                result[j++] = separator;
                segCount = 0;
            }
            ++segCount;
            result[j++] = c;
            ++i;
        }
        return result;
    }

    public static char[] quote(char[] string) {
        return CharArrayTools.delimit(string, '\"');
    }

    public static char[] delimit(char[] string, char delimiter) {
        int stringLength = string.length;
        StringBuilder sb = new StringBuilder(stringLength + 2);
        StringBuilderTools.delimit(sb, string, delimiter, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] delimit(char[] string, char[] delimiter) {
        return CharArrayTools.delimit(string, delimiter, delimiter.length);
    }

    static char[] delimit(char[] string, char[] delimiter, int delimiterLength) {
        switch (delimiterLength) {
            case 0: {
                return string;
            }
            case 1: {
                return CharArrayTools.delimit(string, delimiter[0]);
            }
        }
        return CharArrayTools.delimit_(string, delimiter, delimiterLength);
    }

    private static char[] delimit_(char[] string, char[] delimiter, int delimiterLength) {
        int stringLength = string.length;
        char[] result = new char[stringLength + 2 * delimiterLength];
        System.arraycopy(delimiter, 0, result, 0, delimiterLength);
        System.arraycopy(string, 0, result, delimiterLength, stringLength);
        System.arraycopy(delimiter, 0, result, stringLength + delimiterLength, delimiterLength);
        return result;
    }

    public static boolean isQuoted(char[] string) {
        return CharArrayTools.isDelimited(string, '\"');
    }

    public static boolean isParenthetical(char[] string) {
        return CharArrayTools.isDelimited(string, '(', ')');
    }

    public static boolean isBracketed(char[] string) {
        return CharArrayTools.isDelimited(string, '[', ']');
    }

    public static boolean isBraced(char[] string) {
        return CharArrayTools.isDelimited(string, '{', '}');
    }

    public static boolean isChevroned(char[] string) {
        return CharArrayTools.isDelimited(string, '<', '>');
    }

    public static boolean isDelimited(char[] string, char c) {
        return CharArrayTools.isDelimited(string, c, c);
    }

    public static boolean isDelimited(char[] string, char start, char end) {
        int stringLength = string.length;
        return stringLength < 2 ? false : CharArrayTools.isDelimited(string, start, end, stringLength);
    }

    private static boolean isDelimited(char[] string, char start, char end, int stringLength) {
        return string[0] == start && string[stringLength - 1] == end;
    }

    public static char[] undelimit(char[] string) {
        int stringLength = string.length;
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (resultLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(resultLength);
        StringBuilderTools.undelimit_(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] undelimit(char[] string, int count) {
        if (count == 0) {
            return string;
        }
        int resultLength = string.length - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (resultLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        return CharArrayTools.undelimit(string, count, resultLength);
    }

    private static char[] undelimit(char[] string, int count, int resultLength) {
        return ArrayTools.subArrayLength(string, count, resultLength);
    }

    public static char[] removeFirstOccurrence(char[] string, char c) {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            return string;
        }
        int last = string.length - 1;
        char[] result = new char[last];
        if (index == 0) {
            System.arraycopy(string, 1, result, 0, last);
        } else if (index == last) {
            System.arraycopy(string, 0, result, 0, last);
        } else {
            System.arraycopy(string, 0, result, 0, index);
            System.arraycopy(string, index + 1, result, index, last - index);
        }
        return result;
    }

    public static char[] removeAllOccurrences(char[] string, char c) {
        int first = ArrayTools.indexOf(string, c);
        return first == -1 ? string : CharArrayTools.removeAllOccurrences(string, c, first);
    }

    private static char[] removeAllOccurrences(char[] string, char c, int first) {
        int stringLength = string.length;
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.removeAllOccurrences(sb, string, c, first, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] removeAllSpaces(char[] string) {
        return CharArrayTools.removeAllOccurrences(string, ' ');
    }

    public static char[] removeAllWhitespace(char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        return first == -1 ? string : CharArrayTools.removeAllWhitespace(string, first);
    }

    public static int indexOfWhitespace(char[] string) {
        int stringLength = string.length;
        int i = 0;
        while (i < stringLength) {
            if (Character.isWhitespace(string[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static char[] removeAllWhitespace(char[] string, int first) {
        int stringLength = string.length;
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.removeAllWhitespace(sb, string, first, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] compressWhitespace(char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        return first == -1 ? string : CharArrayTools.compressWhitespace(string, first);
    }

    private static char[] compressWhitespace(char[] string, int first) {
        int stringLength = string.length;
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.compressWhitespace(sb, string, first, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static int commonPrefixLength(char[] s1, char[] s2) {
        return CharArrayTools.commonPrefixLength(s1, s2, Math.min(s1.length, s2.length));
    }

    public static int commonPrefixLength(char[] s1, char[] s2, int max) {
        int i = 0;
        while (i < max) {
            if (s1[i] != s2[i]) {
                return i;
            }
            ++i;
        }
        return max;
    }

    public static char[] capitalize(char[] string) {
        int stringLength = string.length;
        return stringLength == 0 || Character.isUpperCase(string[0]) ? string : CharArrayTools.capitalize(string, stringLength);
    }

    private static char[] capitalize(char[] string, int stringLength) {
        char[] result = new char[stringLength];
        result[0] = Character.toUpperCase(string[0]);
        System.arraycopy(string, 1, result, 1, stringLength - 1);
        return result;
    }

    public static char[] uncapitalize(char[] string) {
        int stringLength = string.length;
        return CharArrayTools.needNotBeUncapitalized(string, stringLength) ? string : CharArrayTools.uncapitalize(string, stringLength);
    }

    public static boolean needNotBeUncapitalized(char[] string, int stringLength) {
        if (stringLength == 0) {
            return true;
        }
        if (Character.isLowerCase(string[0])) {
            return true;
        }
        return stringLength > 1 && Character.isUpperCase(string[1]) && Character.isUpperCase(string[0]);
    }

    private static char[] uncapitalize(char[] string, int stringLength) {
        char[] result = new char[stringLength];
        result[0] = Character.toLowerCase(string[0]);
        System.arraycopy(string, 1, result, 1, stringLength - 1);
        return result;
    }

    public static boolean isBlank(char[] string) {
        if (string == null) {
            return true;
        }
        int stringLength = string.length;
        if (stringLength == 0) {
            return true;
        }
        return CharArrayTools.isBlank(string, stringLength);
    }

    private static boolean isBlank(char[] string, int stringLength) {
        int i = stringLength;
        while (i-- > 0) {
            if (Character.isWhitespace(string[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(char[] string) {
        return !CharArrayTools.isBlank(string);
    }

    public static boolean equalsIgnoreCase(char[] s1, char[] s2) {
        return s1 == null ? s2 == null : s2 != null && CharArrayTools.equalsIgnoreCase_(s1, s2);
    }

    private static boolean equalsIgnoreCase_(char[] s1, char[] s2) {
        int stringLength = s1.length;
        if (stringLength != s2.length) {
            return false;
        }
        int i = stringLength;
        while (i-- > 0) {
            if (CharacterTools.equalsIgnoreCase(s1[i], s2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(char[] string, char[] prefix) {
        int prefixLength = prefix.length;
        if (string.length < prefixLength) {
            return false;
        }
        int i = prefixLength;
        while (i-- > 0) {
            if (CharacterTools.equalsIgnoreCase(string[i], prefix[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isUppercase(char[] string) {
        return string.length != 0 && StringTools.isUppercase_(new String(string));
    }

    public static boolean isLowercase(char[] string) {
        return string.length != 0 && StringTools.isLowercase_(new String(string));
    }

    public static byte[] convertHexStringToByteArray(char[] hexString) {
        int hexStringLength = hexString.length;
        if (hexStringLength == 0) {
            return ByteArrayTools.EMPTY_BYTE_ARRAY;
        }
        if (BitTools.isOdd(hexStringLength)) {
            throw new IllegalArgumentException("Odd-sized hexadecimal string: " + new String(hexString) + " (" + hexStringLength + " characters)");
        }
        return CharArrayTools.convertHexStringToByteArray(hexString, hexStringLength);
    }

    private static byte[] convertHexStringToByteArray(char[] hexString, int hexStringLength) {
        byte[] bytes = new byte[BitTools.half(hexStringLength)];
        int bi = bytes.length - 1;
        int si = hexStringLength - 2;
        while (bi >= 0) {
            byte digit1 = (byte)Character.digit(hexString[si], 16);
            if (digit1 == -1) {
                throw new IllegalArgumentException(CharArrayTools.buildIllegalHexCharMessage(hexString, si));
            }
            byte digit2 = (byte)Character.digit(hexString[si + 1], 16);
            if (digit2 == -1) {
                throw new IllegalArgumentException(CharArrayTools.buildIllegalHexCharMessage(hexString, si + 1));
            }
            bytes[bi] = (byte)((digit1 << 4) + digit2);
            --bi;
            si -= 2;
        }
        return bytes;
    }

    private static String buildIllegalHexCharMessage(char[] hexString, int index) {
        return StringTools.buildIllegalHexCharMessage(new String(hexString), index);
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString) {
        int stringLength = camelCaseString.length;
        return stringLength == 0 ? camelCaseString : CharArrayTools.convertCamelCaseToAllCaps_(camelCaseString, stringLength);
    }

    private static char[] convertCamelCaseToAllCaps_(char[] camelCaseString, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength + stringLength / 4);
        StringBuilderTools.convertCamelCaseToAllCaps_(sb, camelCaseString, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString, int maxLength) {
        if (maxLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int stringLength = camelCaseString.length;
        return stringLength == 0 ? camelCaseString : CharArrayTools.convertCamelCaseToAllCaps(camelCaseString, maxLength, stringLength);
    }

    private static char[] convertCamelCaseToAllCaps(char[] camelCaseString, int maxLength, int stringLength) {
        StringBuilder sb = new StringBuilder(maxLength);
        StringBuilderTools.convertCamelCaseToAllCaps(sb, camelCaseString, maxLength, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertAllCapsToCamelCase(char[] allCapsString) {
        return CharArrayTools.convertAllCapsToCamelCase(allCapsString, true);
    }

    public static char[] convertAllCapsToCamelCase(char[] allCapsString, boolean capitalizeFirstLetter) {
        int stringLength = allCapsString.length;
        return stringLength == 0 ? allCapsString : CharArrayTools.convertAllCapsToCamelCase(allCapsString, capitalizeFirstLetter, stringLength);
    }

    private static char[] convertAllCapsToCamelCase(char[] allCapsString, boolean capitalizeFirstLetter, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, capitalizeFirstLetter, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToJavaStringLiteral(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_JAVA_STRING_LITERAL;
        }
        StringBuilder sb = new StringBuilder(stringLength + 6);
        StringBuilderTools.convertToJavaStringLiteral(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToJavaStringLiteralContent(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(stringLength + 6);
        StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToXmlAttributeValue(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_XML_ATTRIBUTE_VALUE;
        }
        StringBuilder sb = new StringBuilder(stringLength + 12);
        StringBuilderTools.convertToXmlAttributeValue(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToDoubleQuotedXmlAttributeValue(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE;
        }
        StringBuilder sb = new StringBuilder(stringLength + 12);
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToDoubleQuotedXmlAttributeValueContent(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(stringLength + 10);
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToSingleQuotedXmlAttributeValue(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_SINGLE_QUOTED_XML_ATTRIBUTE_VALUE;
        }
        StringBuilder sb = new StringBuilder(stringLength + 12);
        StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToSingleQuotedXmlAttributeValueContent(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(stringLength + 10);
        StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToXmlElementText(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return string;
        }
        StringBuilder sb = new StringBuilder(stringLength + 8);
        StringBuilderTools.convertToXmlElementText(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToXmlElementCDATA(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_XML_ELEMENT_CDATA;
        }
        StringBuilder sb = new StringBuilder(stringLength + EMPTY_XML_ELEMENT_CDATA.length + 6);
        StringBuilderTools.convertToXmlElementCDATA(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToXmlElementCDATAContent(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(stringLength + 6);
        StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static int codePointAt(char[] string, int index) {
        return Character.codePointAt(string, index);
    }

    public static int codePointBefore(char[] string, int index) {
        return Character.codePointBefore(string, index);
    }

    public static int codePointCount(char[] string, int beginIndex, int endIndex) {
        return Character.codePointCount(string, beginIndex, endIndex - beginIndex);
    }

    public static int compareTo(char[] s1, char[] s2) {
        int len1 = s1.length;
        int len2 = s2.length;
        int lim = Math.min(len1, len2);
        int i = 0;
        while (i < lim) {
            char c1 = s1[i];
            char c2 = s2[i];
            if (c1 != c2) {
                return c1 - c2;
            }
            ++i;
        }
        return len1 - len2;
    }

    public static int compareToIgnoreCase(char[] s1, char[] s2) {
        return CASE_INSENSITIVE_ORDER.compare(s1, s2);
    }

    public static char[] concat(char[] s1, char[] s2) {
        int len1 = s1.length;
        if (len1 == 0) {
            return s2;
        }
        int len2 = s2.length;
        if (len2 == 0) {
            return s1;
        }
        char[] buffer = new char[len1 + len2];
        System.arraycopy(s1, 0, buffer, 0, len1);
        System.arraycopy(s2, 0, buffer, len1, len2);
        return buffer;
    }

    public static boolean contains(char[] string, CharSequence cs) {
        return CharArrayTools.indexOf(string, cs) > -1;
    }

    public static boolean contains(char[] s1, char[] s2) {
        return CharArrayTools.indexOf(s1, s2) > -1;
    }

    public static boolean contentEquals(char[] string, CharSequence cs) {
        int len = string.length;
        if (len != cs.length()) {
            return false;
        }
        int i = len;
        while (i-- > 0) {
            if (string[i] == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(char[] string, StringBuffer sb) {
        StringBuffer stringBuffer = sb;
        synchronized (stringBuffer) {
            return CharArrayTools.contentEquals(string, (CharSequence)sb);
        }
    }

    public static boolean endsWith(char[] string, char[] suffix) {
        return CharArrayTools.startsWith(string, suffix, string.length - suffix.length);
    }

    public static byte[] getBytes(char[] string) {
        return String.valueOf(string).getBytes();
    }

    public static byte[] getBytes(char[] string, String charsetName) throws UnsupportedEncodingException {
        return String.valueOf(string).getBytes(charsetName);
    }

    public static void getChars(char[] string, int srcBegin, int srcEnd, char[] dest, int destBegin) {
        System.arraycopy(string, srcBegin, dest, destBegin, srcEnd - srcBegin);
    }

    public static int indexOf(char[] string, int c) {
        return CharArrayTools.indexOf(string, c, 0);
    }

    public static int indexOf(char[] string, int c, int fromIndex) {
        return String.valueOf(string).indexOf(c, fromIndex);
    }

    public static int indexOf(char[] string, CharSequence cs) {
        return CharArrayTools.indexOf(string, cs, 0);
    }

    public static int indexOf(char[] s1, char[] s2) {
        return CharArrayTools.indexOf(s1, s2, 0);
    }

    public static int indexOf(char[] string, CharSequence cs, int fromIndex) {
        int len1 = string.length;
        int len2 = cs.length();
        if (fromIndex >= len1) {
            return len2 == 0 ? len1 : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (len2 == 0) {
            return fromIndex;
        }
        char first = cs.charAt(0);
        int max = len1 - len2;
        int i = fromIndex;
        while (i <= max) {
            if (string[i] != first) {
                while (++i <= max && string[i] != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + len2 - 1;
                int k = 1;
                while (j < end && string[j] == cs.charAt(k)) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char[] s1, char[] s2, int fromIndex) {
        int len1 = s1.length;
        int len2 = s2.length;
        if (fromIndex >= len1) {
            return len2 == 0 ? len1 : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (len2 == 0) {
            return fromIndex;
        }
        char first = s2[0];
        int max = len1 - len2;
        int i = fromIndex;
        while (i <= max) {
            if (s1[i] != first) {
                while (++i <= max && s1[i] != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + len2 - 1;
                int k = 1;
                while (j < end && s1[j] == s2[k]) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] string, int c) {
        return CharArrayTools.indexOf(string, c, string.length - 1);
    }

    public static int lastIndexOf(char[] string, int c, int fromIndex) {
        return String.valueOf(string).lastIndexOf(c, fromIndex);
    }

    public static int lastIndexOf(char[] s1, char[] s2) {
        return CharArrayTools.lastIndexOf(s1, s2, s1.length);
    }

    public static int lastIndexOf(char[] s1, char[] s2, int fromIndex) {
        int start;
        if (fromIndex < 0) {
            return -1;
        }
        int len1 = s1.length;
        int len2 = s2.length;
        int rightIndex = len1 - len2;
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (len2 == 0) {
            return fromIndex;
        }
        int strLastIndex = len2 - 1;
        char strLastChar = s2[strLastIndex];
        int min = len2 - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && s1[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (len2 - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (s1[j--] == s2[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean matches(char[] string, char[] regex) {
        return CharArrayTools.matches(string, String.valueOf(regex));
    }

    public static boolean matches(char[] string, String regex) {
        return String.valueOf(string).matches(regex);
    }

    public static int offsetByCodePoints(char[] string, int index, int codePointOffset) {
        return Character.offsetByCodePoints(string, 0, string.length, index, codePointOffset);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean regionMatches(char[] s1, boolean ignoreCase, int offset1, char[] s2, int offset2, int len) {
        if (offset1 >= 0 && offset2 >= 0 && (long)offset1 <= (long)s1.length - (long)len && (long)offset2 <= (long)s2.length - (long)len) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if ((c1 = s1[offset1++]) == (c2 = s2[offset2++]) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
lbl5:
            // 2 sources

            ** while (len-- > 0)
        }
lbl6:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean regionMatches(char[] s1, int offset1, char[] s2, int offset2, int len) {
        if (offset2 >= 0 && offset1 >= 0 && (long)offset1 <= (long)s1.length - (long)len && (long)offset2 <= (long)s2.length - (long)len) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if (s1[offset1++] == s2[offset2++]) continue;
            return false;
lbl5:
            // 2 sources

            ** while (len-- > 0)
        }
lbl6:
        // 1 sources

        return true;
    }

    public static char[] replace(char[] string, char oldChar, char newChar) {
        if (oldChar == newChar) {
            return string;
        }
        int len = string.length;
        int i = -1;
        while (++i < len) {
            if (string[i] == oldChar) break;
        }
        if (i == len) {
            return string;
        }
        char[] result = new char[len];
        int j = 0;
        while (j < i) {
            result[j] = string[j];
            ++j;
        }
        while (i < len) {
            char c = string[i];
            result[i] = c == oldChar ? newChar : c;
            ++i;
        }
        return result;
    }

    public static char[] replace(char[] string, CharSequence target, CharSequence replacement) {
        return String.valueOf(string).replace(target, replacement).toCharArray();
    }

    public static char[] replace(char[] string, char[] target, char[] replacement) {
        return CharArrayTools.replace(string, String.valueOf(target), String.valueOf(replacement));
    }

    public static char[] replaceAll(char[] string, char[] regex, char[] replacement) {
        return CharArrayTools.replaceAll(string, String.valueOf(regex), replacement);
    }

    public static char[] replaceAll(char[] string, String regex, char[] replacement) {
        return String.valueOf(string).replaceAll(regex, String.valueOf(replacement)).toCharArray();
    }

    public static char[] replaceFirst(char[] string, char[] regex, char[] replacement) {
        return CharArrayTools.replaceFirst(string, String.valueOf(regex), replacement);
    }

    public static char[] replaceFirst(char[] string, String regex, char[] replacement) {
        return String.valueOf(string).replaceFirst(regex, String.valueOf(replacement)).toCharArray();
    }

    public static char[][] split(char[] string, char[] regex) {
        return CharArrayTools.split(string, regex, 0);
    }

    public static char[][] split(char[] string, String regex) {
        return CharArrayTools.split(string, regex, 0);
    }

    public static char[][] split(char[] string, char[] regex, int limit) {
        return CharArrayTools.split(string, String.valueOf(regex), limit);
    }

    public static char[][] split(char[] string, String regex, int limit) {
        String[] strings = String.valueOf(string).split(regex, limit);
        char[][] result = new char[strings.length][];
        int i = result.length;
        while (i-- > 0) {
            result[i] = strings[i].toCharArray();
        }
        return result;
    }

    public static boolean startsWith(char[] string, char[] prefix) {
        return CharArrayTools.startsWith(string, prefix, 0);
    }

    public static boolean startsWith(char[] string, char[] prefix, int offset) {
        int len = prefix.length;
        if (offset < 0 || offset > string.length - len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (prefix[i] != string[offset++]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static char[] subSequence(char[] string, int beginIndex, int endIndex) {
        return CharArrayTools.substring(string, beginIndex, endIndex);
    }

    public static char[] substring(char[] string, int beginIndex) {
        return CharArrayTools.substring(string, beginIndex, string.length);
    }

    public static char[] substring(char[] string, int beginIndex, int endIndex) {
        return ArrayTools.subArray(string, beginIndex, endIndex);
    }

    public static char[] toLowerCase(char[] string) {
        return CharArrayTools.toLowerCase(string, Locale.getDefault());
    }

    public static char[] toLowerCase(char[] string, Locale locale) {
        return String.valueOf(string).toLowerCase(locale).toCharArray();
    }

    public static char[] toUpperCase(char[] string) {
        return CharArrayTools.toLowerCase(string, Locale.getDefault());
    }

    public static char[] toUpperCase(char[] string, Locale locale) {
        return String.valueOf(string).toUpperCase(locale).toCharArray();
    }

    public static char[] trim(char[] string) {
        int end = string.length;
        int start = 0;
        while (start < end && string[start] <= ' ') {
            ++start;
        }
        while (start < end && string[end - 1] <= ' ') {
            --end;
        }
        return start > 0 || end < string.length ? CharArrayTools.substring(string, start, end) : string;
    }

    private CharArrayTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Capitalizer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        Capitalizer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.capitalize(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return CAPITALIZER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseInsensitiveComparator
    implements Comparator<char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CaseInsensitiveComparator() {
        }

        @Override
        public int compare(char[] s1, char[] s2) {
            int len1 = s1.length;
            int len2 = s2.length;
            int i1 = 0;
            int i2 = 0;
            while (i1 < len1 && i2 < len2) {
                char c1 = s1[i1];
                char c2 = s2[i2];
                if (c1 != c2 && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
                ++i1;
                ++i2;
            }
            return len1 - len2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharArrayDelimiter
    implements Transformer<char[], char[]> {
        private final char[] delimiter;
        private final int delimiterLength;

        public CharArrayDelimiter(char[] delimiter) {
            this.delimiter = delimiter;
            this.delimiterLength = delimiter.length;
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.delimit(string, this.delimiter, this.delimiterLength);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.delimiter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharDelimiter
    implements Transformer<char[], char[]> {
        private final char delimiter;

        public CharDelimiter(char delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.delimit(string, this.delimiter);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.delimiter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DoubleQuotedXmlAttributeValueTransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        DoubleQuotedXmlAttributeValueTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToDoubleQuotedXmlAttributeValue(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IsNotBlank
    implements Predicate<char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        IsNotBlank() {
        }

        @Override
        public boolean evaluate(char[] string) {
            return CharArrayTools.isNotBlank(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return IS_NOT_BLANK;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavaStringLiteralContentTransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        JavaStringLiteralContentTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToJavaStringLiteralContent(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return JAVA_STRING_LITERAL_CONTENT_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavaStringLiteralTransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        JavaStringLiteralTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToJavaStringLiteral(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return JAVA_STRING_LITERAL_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingleQuotedXmlAttributeValueTransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SingleQuotedXmlAttributeValueTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToSingleQuotedXmlAttributeValue(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Uncapitalizer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        Uncapitalizer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.uncapitalize(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return UNCAPITALIZER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlAttributeValueTransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlAttributeValueTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToXmlAttributeValue(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_ATTRIBUTE_VALUE_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlDoubleQuotedAttributeValueContentTransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlDoubleQuotedAttributeValueContentTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToDoubleQuotedXmlAttributeValueContent(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_DOUBLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlElementCDATAContentTransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlElementCDATAContentTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToXmlElementCDATAContent(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_ELEMENT_CDATA_CONTENT_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlElementCDATATransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlElementCDATATransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToXmlElementCDATA(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_ELEMENT_CDATA_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlElementTextTransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlElementTextTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToXmlElementText(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_ELEMENT_TEXT_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlSingleQuotedAttributeValueContentTransformer
    implements Transformer<char[], char[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlSingleQuotedAttributeValueContentTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToSingleQuotedXmlAttributeValueContent(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_SINGLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
        }
    }
}

