/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import org.eclipse.jpt.common.utility.internal.ObjectTools;

public final class RunnableSystemExit
implements Runnable {
    private final int wait;
    private final int exitStatus;

    public RunnableSystemExit(int wait, int exitStatus) {
        this.wait = wait;
        this.exitStatus = exitStatus;
    }

    public void run() {
        long stop = System.currentTimeMillis() + (long)this.wait;
        long remaining = this.wait;
        while (remaining > 0L) {
            try {
                Thread.sleep(remaining);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            remaining = stop - System.currentTimeMillis();
        }
        System.exit(this.exitStatus);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, "wait=" + this.wait + "; exit status=" + this.exitStatus);
    }
}

