/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.TypeDeclarationTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJavaType
implements JavaType,
Cloneable,
Serializable {
    private final String elementTypeName;
    private final int arrayDepth;
    private static final String BRACKETS = "[]";
    private static final long serialVersionUID = 1L;
    private static final HashMap<String, JavaType> stardardJavaTypesCache = new HashMap();

    public static JavaType buildSimpleJavaType(String elementTypeName, int arrayDepth) {
        if (arrayDepth == 0) {
            JavaType javaType = stardardJavaTypesCache.get(elementTypeName);
            if (javaType != null) {
                return javaType;
            }
            if (elementTypeName.startsWith("java.lang.") || elementTypeName.startsWith("java.util.") || elementTypeName.startsWith("java.sql.")) {
                javaType = new SimpleJavaType(elementTypeName, arrayDepth);
                stardardJavaTypesCache.put(elementTypeName, javaType);
                return javaType;
            }
        }
        return new SimpleJavaType(elementTypeName, arrayDepth);
    }

    public SimpleJavaType(String elementTypeName, int arrayDepth) {
        if (elementTypeName == null || elementTypeName.length() == 0) {
            throw new IllegalArgumentException("The element type name is required.");
        }
        if (ClassNameTools.arrayDepth(elementTypeName) != 0) {
            throw new IllegalArgumentException("The element type must not be an array: " + elementTypeName + '.');
        }
        if (arrayDepth < 0) {
            throw new IllegalArgumentException("The array depth must be greater than or equal to zero: " + arrayDepth + '.');
        }
        if (elementTypeName.equals(Void.TYPE.getName()) && arrayDepth != 0) {
            throw new IllegalArgumentException("'void' must have an array depth of zero: " + arrayDepth + '.');
        }
        this.elementTypeName = elementTypeName;
        this.arrayDepth = arrayDepth;
    }

    public SimpleJavaType(String javaClassName) {
        this(ClassNameTools.elementTypeName(javaClassName), ClassNameTools.arrayDepth(javaClassName));
    }

    public SimpleJavaType(Class<?> javaClass) {
        this(javaClass.getName());
    }

    @Override
    public String getElementTypeName() {
        return this.elementTypeName;
    }

    @Override
    public int getArrayDepth() {
        return this.arrayDepth;
    }

    @Override
    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    @Override
    public boolean isPrimitive() {
        return this.arrayDepth == 0 && ClassNameTools.isPrimitive(this.elementTypeName);
    }

    @Override
    public boolean isPrimitiveWrapper() {
        return this.arrayDepth == 0 && ClassNameTools.isPrimitiveWrapper(this.elementTypeName);
    }

    @Override
    public boolean isVariablePrimitive() {
        return this.arrayDepth == 0 && ClassNameTools.isVariablePrimitive(this.elementTypeName);
    }

    @Override
    public boolean isVariablePrimitiveWrapper() {
        return this.arrayDepth == 0 && ClassNameTools.isVariablePrimitiveWrapper(this.elementTypeName);
    }

    @Override
    public Class<?> getJavaClass() throws ClassNotFoundException {
        return ClassTools.forTypeDeclaration(this.elementTypeName, this.arrayDepth);
    }

    @Override
    public String getJavaClassName() {
        return TypeDeclarationTools.className(this.elementTypeName, this.arrayDepth);
    }

    @Override
    public boolean equals(String otherElementTypeName, int otherArrayDepth) {
        return this.arrayDepth == otherArrayDepth && this.elementTypeName.equals(otherElementTypeName);
    }

    @Override
    public boolean describes(String className) {
        return this.equals(ClassNameTools.elementTypeName(className), ClassNameTools.arrayDepth(className));
    }

    @Override
    public boolean describes(Class<?> javaClass) {
        return this.describes(javaClass.getName());
    }

    @Override
    public boolean equals(JavaType other) {
        return this.equals(other.getElementTypeName(), other.getArrayDepth());
    }

    public boolean equals(Object o) {
        return this == o ? true : (o instanceof JavaType ? this.equals((JavaType)o) : false);
    }

    public int hashCode() {
        return this.elementTypeName.hashCode() ^ this.arrayDepth;
    }

    @Override
    public String declaration() {
        if (this.arrayDepth == 0) {
            return this.getElementTypeNameDeclaration();
        }
        StringBuilder sb = new StringBuilder(this.elementTypeName.length() + 2 * this.arrayDepth);
        this.appendDeclarationTo(sb);
        return sb.toString();
    }

    @Override
    public void appendDeclarationTo(StringBuilder sb) {
        sb.append(this.getElementTypeNameDeclaration());
        int i = this.arrayDepth;
        while (i-- > 0) {
            sb.append(BRACKETS);
        }
    }

    @Override
    public void printDeclarationOn(PrintWriter pw) {
        pw.print(this.getElementTypeNameDeclaration());
        int i = this.arrayDepth;
        while (i-- > 0) {
            pw.print(BRACKETS);
        }
    }

    private String getElementTypeNameDeclaration() {
        return this.elementTypeName.replace('$', '.');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        this.appendDeclarationTo(sb);
        sb.append(')');
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

