/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalInterruptibleClosure<A>
implements InterruptibleClosure<A> {
    private final ThreadLocal<InterruptibleClosure<? super A>> threadLocal;
    private final InterruptibleClosure<? super A> defaultInterruptibleClosure;

    public ThreadLocalInterruptibleClosure(InterruptibleClosure<? super A> defaultInterruptibleClosure) {
        if (defaultInterruptibleClosure == null) {
            throw new NullPointerException();
        }
        this.defaultInterruptibleClosure = defaultInterruptibleClosure;
        this.threadLocal = this.buildThreadLocal();
    }

    private ThreadLocal<InterruptibleClosure<? super A>> buildThreadLocal() {
        return new ThreadLocal<InterruptibleClosure<? super A>>();
    }

    @Override
    public void execute(A argument) throws InterruptedException {
        this.get().execute(argument);
    }

    private InterruptibleClosure<? super A> get() {
        InterruptibleClosure<? super A> closure = this.threadLocal.get();
        if (closure != null) {
            return closure;
        }
        return this.defaultInterruptibleClosure;
    }

    public void set(InterruptibleClosure<? super A> closure) {
        this.threadLocal.set(closure);
    }

    public String toString() {
        return this.get().toString();
    }
}

