/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedListIterator<E>
implements ListIterator<E> {
    private final ListIterator<E> listIterator;
    private final Object mutex;

    public SynchronizedListIterator(ListIterator<E> listIterator) {
        if (listIterator == null) {
            throw new NullPointerException();
        }
        this.listIterator = listIterator;
        this.mutex = this;
    }

    public SynchronizedListIterator(ListIterator<E> listIterator, Object mutex) {
        if (listIterator == null || mutex == null) {
            throw new NullPointerException();
        }
        this.listIterator = listIterator;
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextIndex() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.nextIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPrevious() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.hasPrevious();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E previous() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.previous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int previousIndex() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.previousIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Object object = this.mutex;
        synchronized (object) {
            this.listIterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(E e) {
        Object object = this.mutex;
        synchronized (object) {
            this.listIterator.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(E e) {
        Object object = this.mutex;
        synchronized (object) {
            this.listIterator.set(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return ObjectTools.toString((Object)this, this.listIterator);
        }
    }
}

