/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverWrapper
implements Driver {
    private final Driver driver;

    public DriverWrapper(String driverClassName, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this(Class.forName(driverClassName, true, classLoader));
    }

    public DriverWrapper(Class<Driver> driverClass) throws InstantiationException, IllegalAccessException {
        this(driverClass.newInstance());
    }

    public DriverWrapper(Driver driver) {
        if (driver == null) {
            throw new NullPointerException();
        }
        this.driver = driver;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.driver.connect(url, info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.driver.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.driver.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.driver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.driver.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.driver.jdbcCompliant();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.driver);
    }
}

