/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoublePropertyValueModel<V, VMVM extends PropertyValueModel<? extends V>>
extends PropertyValueModelWrapper<VMVM>
implements PropertyValueModel<V> {
    protected volatile VMVM valueModelValueModel;
    protected final PropertyChangeListener valueModelValueListener = this.buildValueModelValueListener();
    private volatile V value;

    protected AbstractDoublePropertyValueModel(PropertyValueModel<? extends VMVM> valueModel) {
        super(valueModel);
    }

    protected PropertyChangeListener buildValueModelValueListener() {
        return new ValueModelValueListener();
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    protected void wrappedValueChanged(VMVM newValue) {
        if (this.hasListeners()) {
            V old = this.value;
            this.disengageValueModelValueModel();
            this.engageValueModelValueModel();
            this.firePropertyChanged("value", old, this.value);
        }
    }

    protected void wrappedValueModelValueChanged(PropertyChangeEvent event) {
        V old = this.value;
        this.value = event.getNewValue();
        this.firePropertyChanged("value", old, this.value);
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.engageValueModelValueModel();
    }

    protected void engageValueModelValueModel() {
        this.valueModelValueModel = (PropertyValueModel)this.valueModel.getValue();
        if (this.valueModelValueModel != null) {
            this.valueModelValueModel.addPropertyChangeListener("value", this.valueModelValueListener);
            this.value = this.valueModelValueModel.getValue();
        }
    }

    @Override
    protected void disengageModel() {
        this.disengageValueModelValueModel();
        super.disengageModel();
    }

    protected void disengageValueModelValueModel() {
        if (this.valueModelValueModel != null) {
            this.value = null;
            this.valueModelValueModel.removePropertyChangeListener("value", this.valueModelValueListener);
            this.valueModelValueModel = null;
        }
    }

    class ValueModelValueListener
    extends PropertyChangeAdapter {
        ValueModelValueListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            AbstractDoublePropertyValueModel.this.wrappedValueModelValueChanged(event);
        }
    }
}

