/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.predicate;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPredicate<V>
implements Predicate<V> {
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final Object[] arguments;

    public MethodPredicate(String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        if (methodName == null || parameterTypes == null || arguments == null) {
            throw new NullPointerException();
        }
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
    }

    @Override
    public boolean evaluate(V variable) {
        return this.evaluate_(variable);
    }

    private Boolean evaluate_(V variable) {
        return (Boolean)ObjectTools.execute(variable, this.methodName, this.parameterTypes, this.arguments);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodPredicate)) {
            return false;
        }
        MethodPredicate other = (MethodPredicate)o;
        return ObjectTools.equals(this.methodName, other.methodName) && Arrays.equals(this.parameterTypes, other.parameterTypes) && Arrays.equals(this.arguments, other.arguments);
    }

    public int hashCode() {
        return this.methodName.hashCode() ^ Arrays.hashCode(this.parameterTypes) ^ Arrays.hashCode(this.arguments);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, ClassTools.buildMethodSignature(this.methodName, this.parameterTypes));
    }
}

