/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchTransformer<I, O>
implements Transformer<I, O> {
    private final Iterable<Association<Predicate<? super I>, Transformer<? super I, ? extends O>>> transformers;
    private final Transformer<? super I, ? extends O> defaultTransformer;

    public SwitchTransformer(Iterable<Association<Predicate<? super I>, Transformer<? super I, ? extends O>>> transformers, Transformer<? super I, ? extends O> defaultTransformer) {
        if (IterableTools.isOrContainsNull(transformers) || defaultTransformer == null) {
            throw new NullPointerException();
        }
        this.transformers = transformers;
        this.defaultTransformer = defaultTransformer;
    }

    @Override
    public O transform(I input) {
        for (Association<Predicate<I>, Transformer<I, O>> association : this.transformers) {
            if (!association.getKey().evaluate(input)) continue;
            return association.getValue().transform(input);
        }
        return this.defaultTransformer.transform(input);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.transformers);
    }
}

