/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Executors {
    private Executors() {
    }

    public static ThreadPoolExecutor coreThreadsTimoutExecutor(int numberOfThreads, int threadPriority, String threadNamePrefix) {
        ThreadFactory factory = new ThreadFactoryBuilder().setPriority(threadPriority).setNameFormat(String.valueOf(threadNamePrefix) + "%d").setDaemon(true).build();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(numberOfThreads, numberOfThreads, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    public static ThreadPoolExecutor coreThreadsTimoutExecutor(int numberOfThreads, int threadPriority, String threadNamePrefix, long timeout, TimeUnit unit) {
        ThreadFactory factory = new ThreadFactoryBuilder().setPriority(threadPriority).setNameFormat(String.valueOf(threadNamePrefix) + "%d").setDaemon(true).build();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(numberOfThreads, numberOfThreads, timeout, unit, new LinkedBlockingQueue<Runnable>(), factory);
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }
}

