/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details.db;

import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.internal.widgets.ComboPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Sequence;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.internal.listeners.SWTConnectionListenerWrapper;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseObjectCombo<T extends JpaModel>
extends ComboPane<T> {
    private ConnectionListener connectionListener;
    private PropertyChangeListener connectionProfileListener;
    static final String TRACE_OPTION = DatabaseObjectCombo.class.getSimpleName();

    protected DatabaseObjectCombo(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected DatabaseObjectCombo(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected DatabaseObjectCombo(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite parent) {
        super(parentPane, subjectHolder, enabledModel, parent);
    }

    protected void initialize() {
        super.initialize();
        this.connectionListener = this.buildConnectionListener();
        this.connectionProfileListener = this.buildConnectionProfileListener();
    }

    protected ConnectionListener buildConnectionListener() {
        return new SWTConnectionListenerWrapper(this.buildConnectionListener_());
    }

    protected ConnectionListener buildConnectionListener_() {
        return new LocalConnectionListener();
    }

    protected PropertyChangeListener buildConnectionProfileListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)this.buildConnectionProfileListener_());
    }

    protected PropertyChangeListener buildConnectionProfileListener_() {
        return new ConnectionProfileListener();
    }

    protected void connectionProfileChanged(PropertyChangeEvent event) {
        if (event.getOldValue() != null) {
            ((ConnectionProfile)event.getOldValue()).removeConnectionListener(this.connectionListener);
        }
        if (event.getNewValue() != null) {
            ((ConnectionProfile)event.getNewValue()).addConnectionListener(this.connectionListener);
        }
        this.repopulateComboBox();
    }

    protected void engageListeners_(T subject) {
        super.engageListeners_(subject);
        subject.getJpaProject().getDataSource().addPropertyChangeListener("connectionProfile", this.connectionProfileListener);
        ConnectionProfile cp = subject.getJpaProject().getConnectionProfile();
        if (cp != null) {
            cp.addConnectionListener(this.connectionListener);
        }
    }

    protected void disengageListeners_(T subject) {
        ConnectionProfile cp = subject.getJpaProject().getConnectionProfile();
        if (cp != null) {
            cp.removeConnectionListener(this.connectionListener);
        }
        subject.getJpaProject().getDataSource().removePropertyChangeListener("connectionProfile", this.connectionProfileListener);
        super.disengageListeners_(subject);
    }

    protected final Iterable<String> getValues() {
        return this.connectionProfileIsActive() ? this.getValues_() : EmptyIterable.instance();
    }

    protected abstract Iterable<String> getValues_();

    protected JpaProject getJpaProject() {
        JpaModel subject = (JpaModel)this.getSubject();
        return subject == null ? null : subject.getJpaProject();
    }

    protected final ConnectionProfile getConnectionProfile() {
        JpaProject jpaProject = this.getJpaProject();
        return jpaProject == null ? null : jpaProject.getConnectionProfile();
    }

    protected final boolean connectionProfileIsActive() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp != null && cp.isActive();
    }

    protected final Database getDatabase() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp == null ? null : cp.getDatabase();
    }

    protected final void databaseChanged(Database database) {
        if (!this.comboBox.isDisposed()) {
            this.databaseChanged_(database);
        }
    }

    protected void databaseChanged_(Database database) {
    }

    protected final void catalogChanged(Catalog catalog) {
        if (!this.comboBox.isDisposed()) {
            this.catalogChanged_(catalog);
        }
    }

    protected void catalogChanged_(Catalog catalog) {
    }

    protected final void schemaChanged(Schema schema) {
        if (!this.comboBox.isDisposed()) {
            this.schemaChanged_(schema);
        }
    }

    protected void schemaChanged_(Schema schema) {
    }

    protected final void sequenceChanged(Sequence sequence) {
        if (!this.comboBox.isDisposed()) {
            this.sequenceChanged_(sequence);
        }
    }

    protected void sequenceChanged_(Sequence sequence) {
    }

    protected final void tableChanged(Table table) {
        if (!this.comboBox.isDisposed()) {
            this.tableChanged_(table);
        }
    }

    protected void tableChanged_(Table table) {
    }

    protected final void columnChanged(Column column) {
        if (!this.comboBox.isDisposed()) {
            this.columnChanged_(column);
        }
    }

    protected void columnChanged_(Column column) {
    }

    protected final void foreignKeyChanged(ForeignKey foreignKey) {
        if (!this.comboBox.isDisposed()) {
            this.foreignKeyChanged_(foreignKey);
        }
    }

    protected void foreignKeyChanged_(ForeignKey foreignKey) {
    }

    protected void repopulateComboBox() {
        super.repopulateComboBox();
    }

    public class ConnectionProfileListener
    implements PropertyChangeListener {
        public void propertyChanged(PropertyChangeEvent event) {
            DatabaseObjectCombo.this.connectionProfileChanged(event);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)((Object)DatabaseObjectCombo.this));
        }
    }

    public class LocalConnectionListener
    implements ConnectionListener {
        public void opened(ConnectionProfile profile) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "opened: {0}", new Object[]{profile});
            DatabaseObjectCombo.this.repopulateComboBox();
        }

        public void modified(ConnectionProfile profile) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "modified: {0}", new Object[]{profile});
            DatabaseObjectCombo.this.repopulateComboBox();
        }

        public boolean okToClose(ConnectionProfile profile) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "OK to close: {0}", new Object[]{profile});
            return true;
        }

        public void aboutToClose(ConnectionProfile profile) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "about to close: {0}", new Object[]{profile});
        }

        public void closed(ConnectionProfile profile) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "closed: {0}", new Object[]{profile});
            DatabaseObjectCombo.this.repopulateComboBox();
        }

        public void databaseChanged(ConnectionProfile profile, Database database) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "database changed: {0}", new Object[]{database});
            DatabaseObjectCombo.this.databaseChanged(database);
        }

        public void catalogChanged(ConnectionProfile profile, Catalog catalog) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "catalog changed: {0}", new Object[]{catalog});
            DatabaseObjectCombo.this.catalogChanged(catalog);
        }

        public void schemaChanged(ConnectionProfile profile, Schema schema) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "schema changed: {0}", new Object[]{schema});
            DatabaseObjectCombo.this.schemaChanged(schema);
        }

        public void sequenceChanged(ConnectionProfile profile, Sequence sequence) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "sequence changed: {0}", new Object[]{sequence});
            DatabaseObjectCombo.this.sequenceChanged(sequence);
        }

        public void tableChanged(ConnectionProfile profile, Table table) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "table changed: {0}", new Object[]{table});
            DatabaseObjectCombo.this.tableChanged(table);
        }

        public void columnChanged(ConnectionProfile profile, Column column) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "column changed: {0}", new Object[]{column});
            DatabaseObjectCombo.this.columnChanged(column);
        }

        public void foreignKeyChanged(ConnectionProfile profile, ForeignKey foreignKey) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "foreign key changed: {0}", new Object[]{foreignKey});
            DatabaseObjectCombo.this.foreignKeyChanged(foreignKey);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)((Object)DatabaseObjectCombo.this));
        }
    }
}

