/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.selection;

import java.util.Hashtable;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.internal.InternalJpaWorkbench;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaWindowSelectionManager;
import org.eclipse.jpt.jpa.ui.internal.selection.SetJpaSelectionJob;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

class JpaWorkbenchSelectionManager
implements JpaSelectionManager,
SetJpaSelectionJob.Manager {
    private final IWorkbench workbench;
    private final Hashtable<IWorkbenchWindow, JpaWindowSelectionManager> windowManagers = new Hashtable();
    private static final String TRACE_OPTION = JpaSelectionManager.class.getSimpleName();

    private JpaWorkbenchSelectionManager(IWorkbench workbench) {
        this.workbench = workbench;
        JptJpaUiPlugin.instance().trace(TRACE_OPTION, "add workbench manager: {0}", new Object[]{workbench});
    }

    public void setSelection(JpaStructureNode selection) {
        new SetJpaSelectionJob(this, selection).schedule();
    }

    public void setSelection_(JpaStructureNode selection) {
        JpaWindowSelectionManager manager;
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window != null && (manager = this.windowManagers.get(window)) != null) {
            manager.setSelection_(selection);
        }
    }

    JpaWindowSelectionManager getWindowManager(IWorkbenchWindow window) {
        return this.windowManagers.get(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JpaWindowSelectionManager getWindowManager_(IWorkbenchWindow window) {
        Hashtable<IWorkbenchWindow, JpaWindowSelectionManager> hashtable = this.windowManagers;
        synchronized (hashtable) {
            JpaWindowSelectionManager manager = this.windowManagers.get(window);
            if (manager == null) {
                JptJpaUiPlugin.instance().trace(TRACE_OPTION, "add window manager: {0}", new Object[]{window});
                manager = new JpaWindowSelectionManager(this, window);
                this.windowManagers.put(window, manager);
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWindowManager(IWorkbenchWindow window) {
        Hashtable<IWorkbenchWindow, JpaWindowSelectionManager> hashtable = this.windowManagers;
        synchronized (hashtable) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "remove window manager: {0}", new Object[]{window});
            this.windowManagers.remove(window);
            if (this.windowManagers.isEmpty()) {
                this.dispose();
            }
        }
    }

    private void dispose() {
        JptJpaUiPlugin.instance().trace(TRACE_OPTION, "remove workbench manager: {0}", new Object[]{this.workbench});
        JpaWorkbenchSelectionManager.getJpaWorkbench(this.workbench).setJpaSelectionManager(null);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.workbench);
    }

    static JpaWorkbenchSelectionManager forWorkbench(IWorkbench workbench) {
        return (JpaWorkbenchSelectionManager)JpaWorkbenchSelectionManager.getJpaWorkbench(workbench).getJpaSelectionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JpaWorkbenchSelectionManager forWorkbench_(IWorkbench workbench) {
        InternalJpaWorkbench jpaWorkbench = JpaWorkbenchSelectionManager.getJpaWorkbench(workbench);
        if (jpaWorkbench == null) {
            return null;
        }
        InternalJpaWorkbench internalJpaWorkbench = jpaWorkbench;
        synchronized (internalJpaWorkbench) {
            JpaWorkbenchSelectionManager manager = (JpaWorkbenchSelectionManager)jpaWorkbench.getJpaSelectionManager();
            if (manager == null) {
                manager = new JpaWorkbenchSelectionManager(workbench);
                jpaWorkbench.setJpaSelectionManager(manager);
            }
            return manager;
        }
    }

    private static InternalJpaWorkbench getJpaWorkbench(IWorkbench workbench) {
        return JptJpaUiPlugin.instance().getJpaWorkbench(workbench);
    }
}

