/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.views;

import java.util.HashMap;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.FormWidgetFactory;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.details.JpaDetailsPageManager;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.selection.JpaViewManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class JpaDetailsView
extends ViewPart {
    public static final String ID = "org.eclipse.jpt.ui.jpaDetailsView";
    private volatile ScrolledForm scrolledForm;
    private volatile PageBook pageBook;
    private volatile Control defaultPage;
    private volatile JpaDetailsPageManager currentPageManager;
    private volatile ResourceManager resourceManager;
    private volatile FormWidgetFactory widgetFactory;
    private volatile Manager manager;
    private final PropertyChangeListener jpaSelectionListener = new JpaSelectionListener();
    private final HashMap<JpaStructureNode.ContextType, JpaDetailsPageManager> pageManagers = new HashMap();

    public void createPartControl(Composite parent) {
        this.resourceManager = this.buildResourceManager();
        this.widgetFactory = new FormWidgetFactory(new FormToolkit(parent.getDisplay()));
        this.scrolledForm = this.widgetFactory.createScrolledForm(parent);
        JptJpaUiPlugin.instance().controlAffectsJavaSource((Control)this.scrolledForm);
        this.scrolledForm.getBody().setLayout((Layout)new GridLayout());
        this.pageBook = new PageBook(this.scrolledForm.getBody(), 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.pageBook.setLayoutData((Object)gridData);
        this.defaultPage = this.buildDefaultPage();
        this.pageBook.showPage(this.defaultPage);
        this.manager = this.buildManager();
        if (this.manager != null) {
            this.manager.getJpaSelectionModel().addPropertyChangeListener("value", this.jpaSelectionListener);
            this.setJpaSelection((JpaStructureNode)this.manager.getJpaSelectionModel().getValue());
        }
    }

    private ResourceManager buildResourceManager() {
        JpaWorkbench jpaWorkbench = this.getJpaWorkbench();
        return jpaWorkbench != null ? jpaWorkbench.buildLocalResourceManager() : new LocalResourceManager(JFaceResources.getResources((Display)this.getWorkbench().getDisplay()));
    }

    private JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)PlatformTools.getAdapter((Object)this.getWorkbench(), JpaWorkbench.class);
    }

    private IWorkbench getWorkbench() {
        return this.getSite().getWorkbenchWindow().getWorkbench();
    }

    private Control buildDefaultPage() {
        return this.widgetFactory.createLabel((Composite)this.pageBook, JptJpaUiMessages.JPA_DETAILS_VIEW_VIEW_NOT_AVAILABLE);
    }

    private Manager buildManager() {
        JpaViewManager.PageManager pageManager = this.getPageManager();
        return pageManager == null ? null : new Manager(pageManager);
    }

    private JpaViewManager.PageManager getPageManager() {
        return (JpaViewManager.PageManager)this.getAdapter(JpaViewManager.PageManager.class);
    }

    void setJpaSelection(JpaStructureNode node) {
        boolean pageChange = false;
        if (node == null) {
            if (this.currentPageManager != null) {
                try {
                    this.currentPageManager.setSubject(null);
                }
                catch (RuntimeException ex) {
                    JptJpaUiPlugin.instance().logError(ex);
                }
                this.currentPageManager = null;
                pageChange = true;
            }
        } else if (this.currentPageManager == null) {
            this.currentPageManager = this.getPageManager(node);
            if (this.currentPageManager != null) {
                try {
                    this.currentPageManager.setSubject(node);
                    pageChange = true;
                }
                catch (RuntimeException ex) {
                    JptJpaUiPlugin.instance().logError(ex);
                    this.currentPageManager = null;
                }
            }
        } else {
            JpaDetailsPageManager pageManager = this.getPageManager(node);
            if (pageManager != this.currentPageManager) {
                try {
                    this.currentPageManager.setSubject(null);
                }
                catch (RuntimeException ex) {
                    JptJpaUiPlugin.instance().logError(ex);
                }
                this.currentPageManager = pageManager;
                pageChange = true;
            }
            if (this.currentPageManager != null) {
                try {
                    this.currentPageManager.setSubject(node);
                }
                catch (RuntimeException ex) {
                    JptJpaUiPlugin.instance().logError(ex);
                    this.currentPageManager = null;
                    pageChange = true;
                }
            }
        }
        if (pageChange) {
            this.pageBook.showPage(this.getCurrentPage());
            this.scrolledForm.reflow(true);
        }
    }

    private Control getCurrentPage() {
        return this.currentPageManager != null ? this.currentPageManager.getPage() : this.defaultPage;
    }

    private JpaDetailsPageManager getPageManager(JpaStructureNode node) {
        JpaStructureNode.ContextType nodeType = node.getContextType();
        JpaDetailsPageManager pageManager = this.pageManagers.get(nodeType);
        if (pageManager == null && (pageManager = this.buildPageManager(node)) != null) {
            this.pageManagers.put(nodeType, pageManager);
        }
        return pageManager;
    }

    private JpaDetailsPageManager buildPageManager(JpaStructureNode node) {
        return this.getJpaDetailsPageManagerFactory(node).buildPageManager((Composite)this.pageBook, (WidgetFactory)this.widgetFactory, this.resourceManager);
    }

    private JpaDetailsPageManager.Factory getJpaDetailsPageManagerFactory(JpaStructureNode node) {
        return (JpaDetailsPageManager.Factory)node.getAdapter(JpaDetailsPageManager.Factory.class);
    }

    public void setFocus() {
        this.pageBook.setFocus();
    }

    public void dispose() {
        if (this.currentPageManager != null) {
            this.currentPageManager.setSubject(null);
            this.currentPageManager = null;
        }
        this.pageManagers.clear();
        if (this.manager != null) {
            this.manager.getJpaSelectionModel().removePropertyChangeListener("value", this.jpaSelectionListener);
            this.manager.dispose();
        }
        if (this.widgetFactory != null) {
            this.widgetFactory.dispose();
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
        super.dispose();
    }

    public String toString() {
        return ObjectTools.toString((Object)((Object)this));
    }

    class JpaSelectionListener
    extends PropertyChangeAdapter {
        JpaSelectionListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JpaDetailsView.this.setJpaSelection((JpaStructureNode)event.getNewValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Manager
    implements JpaViewManager {
        private final JpaViewManager.PageManager pageManager;

        Manager(JpaViewManager.PageManager pageManager) {
            if (pageManager == null) {
                throw new NullPointerException();
            }
            this.pageManager = pageManager;
            this.pageManager.addViewManager(this);
        }

        @Override
        public IViewPart getView() {
            return JpaDetailsView.this;
        }

        ModifiablePropertyValueModel<JpaStructureNode> getJpaSelectionModel() {
            return this.pageManager.getJpaSelectionModel();
        }

        void dispose() {
            this.pageManager.removeViewManager(this);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

