/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import java.util.EventListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.ConnectionAdapter;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class DatabaseSchemaWizardPage
extends WizardPage {
    final JpaProject jpaProject;
    private final ListenerList<Listener> listenerList = new ListenerList(Listener.class);
    private DatabaseGroup databaseGroup;

    public DatabaseSchemaWizardPage(JpaProject jpaProject) {
        super("Database Schema");
        if (jpaProject == null) {
            throw new NullPointerException();
        }
        this.jpaProject = jpaProject;
        this.setTitle(JptJpaUiMessages.DATABASE_SCHEMA_WIZARD_PAGE_TITLE);
        this.setMessage(JptJpaUiMessages.DATABASE_SCHEMA_WIZARD_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl(this.buildTopLevelControl(parent));
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.databaseGroup = new DatabaseGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        WorkbenchTools.setHelp((Control)composite, (String)JpaHelpContextIds.PROPERTIES_JAVA_PERSISTENCE_CONNECTION);
        return composite;
    }

    public ConnectionProfile getJpaProjectConnectionProfile() {
        return this.jpaProject.getConnectionProfile();
    }

    public Schema getSelectedSchema() {
        return this.databaseGroup.getSelectedSchema();
    }

    public void dispose() {
        this.databaseGroup.dispose();
        super.dispose();
    }

    public void addListener(Listener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeListener(Listener listener) {
        this.listenerList.remove((Object)listener);
    }

    void fireSchemaChanged(Schema schema) {
        this.setPageComplete(schema != null);
        for (Listener listener : this.listenerList) {
            listener.selectedSchemaChanged(schema);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DatabaseGroup {
        private Schema selectedSchema;
        private final Combo schemaComboBox;
        private final Link reconnectLink;
        private Link addJpaProjectConnectionLink;
        private final ConnectionListener connectionListener;

        DatabaseGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(768));
            group.setText(JptJpaUiMessages.DATABASE_SCHEMA_WIZARD_PAGE_SCHEMA_SETTINGS);
            this.buildLabel((Composite)group, 1, JptJpaUiMessages.DATABASE_SCHEMA_WIZARD_PAGE_SCHEMA);
            this.schemaComboBox = this.buildComboBox((Composite)group, this.buildSchemaComboBoxSelectionListener());
            String message = this.projectHasAConnection() ? JptJpaUiMessages.DATABASE_SCHEMA_WIZARD_PAGE_SCHEMA_INFO : JptJpaUiMessages.DATABASE_SCHEMA_WIZARD_PAGE_CONNECTION_INFO;
            this.buildLabel((Composite)group, 2, message);
            if (!this.projectHasAConnection()) {
                this.addJpaProjectConnectionLink = this.buildLink((Composite)group, JptJpaUiMessages.DATABASE_SCHEMA_WIZARD_PAGE_ADD_CONNECTION_TO_PROJECT, this.buildAddJpaProjectConnectionLinkListener());
            }
            this.reconnectLink = this.buildLink((Composite)group, JptJpaUiMessages.DATABASE_SCHEMA_WIZARD_PAGE_CONNECT_LINK, this.buildReconnectLinkSelectionListener());
            this.reconnectLink.setEnabled(true);
            this.selectedSchema = this.getDefaultSchema();
            if (this.selectedSchema != null) {
                DatabaseSchemaWizardPage.this.fireSchemaChanged(this.selectedSchema);
            }
            this.connectionListener = this.buildConnectionListener();
            this.addJpaProjectConnectionProfileListener(this.connectionListener);
            this.updateSchemaComboBox();
            this.updateReconnectLink();
        }

        Schema getSelectedSchema() {
            return this.selectedSchema;
        }

        void dispose() {
            if (this.projectHasAConnection()) {
                this.getJpaProjectConnectionProfile().removeConnectionListener(this.connectionListener);
            }
        }

        void addJpaProjectConnectionListener() {
            this.addJpaProjectConnectionProfileListener(this.connectionListener);
        }

        private void addJpaProjectConnectionProfileListener(ConnectionListener listener) {
            if (this.projectHasAConnection()) {
                this.getJpaProjectConnectionProfile().addConnectionListener(listener);
            }
        }

        private boolean projectHasAConnection() {
            return this.getJpaProjectConnectionProfile() != null;
        }

        private ConnectionProfile getJpaProjectConnectionProfile() {
            return DatabaseSchemaWizardPage.this.jpaProject.getConnectionProfile();
        }

        private Schema getDefaultSchema() {
            return DatabaseSchemaWizardPage.this.jpaProject.getDefaultDbSchema();
        }

        private SchemaContainer getDefaultSchemaContainer() {
            return DatabaseSchemaWizardPage.this.jpaProject.getDefaultDbSchemaContainer();
        }

        private void updateReconnectLink() {
            this.reconnectLink.setEnabled(this.reconnectLinkCanBeEnabled());
        }

        void updateAddJpaProjectConnectionLink() {
            this.addJpaProjectConnectionLink.setEnabled(this.addJpaProjectConnectionLinkCanBeEnabled());
        }

        private boolean reconnectLinkCanBeEnabled() {
            if (this.projectHasAConnection()) {
                return this.getJpaProjectConnectionProfile().isInactive();
            }
            return false;
        }

        private boolean addJpaProjectConnectionLinkCanBeEnabled() {
            return !this.projectHasAConnection();
        }

        private void updateSchemaComboBox() {
            this.schemaComboBox.removeAll();
            for (String name : this.getSchemaNames()) {
                this.schemaComboBox.add(name);
            }
            if (this.selectedSchema != null) {
                this.schemaComboBox.select(this.schemaComboBox.indexOf(this.selectedSchema.getName()));
            }
        }

        private Iterable<String> getSchemaNames() {
            SchemaContainer sc = this.getDefaultSchemaContainer();
            return sc != null ? sc.getSortedSchemaNames() : EmptyIterable.instance();
        }

        void selectedSchemaChanged() {
            Schema old = this.selectedSchema;
            this.selectedSchema = this.getDefaultSchemaContainer().getSchemaNamed(this.schemaComboBox.getText());
            if (this.selectedSchema != old) {
                DatabaseSchemaWizardPage.this.fireSchemaChanged(this.selectedSchema);
            }
        }

        void reconnect() {
            this.getJpaProjectConnectionProfile().connect();
        }

        void connectionChanged() {
            Schema old = this.selectedSchema;
            this.selectedSchema = this.getDefaultSchema();
            if (this.selectedSchema != old) {
                DatabaseSchemaWizardPage.this.fireSchemaChanged(this.selectedSchema);
            }
            this.updateSchemaComboBox();
            this.updateReconnectLink();
        }

        private SelectionListener buildSchemaComboBoxSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    DatabaseGroup.this.selectedSchemaChanged();
                }

                public String toString() {
                    return "DatabaseSchemaWizardPage schema combo-box selection listener";
                }
            };
        }

        private SelectionListener buildReconnectLinkSelectionListener() {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DatabaseGroup.this.reconnect();
                }

                public String toString() {
                    return "DatabaseSchemaWizardPage reconnect link selection listener";
                }
            };
        }

        private ConnectionListener buildConnectionListener() {
            return new LocalConnectionListener();
        }

        private SelectionListener buildAddJpaProjectConnectionLinkListener() {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.this.promptToConfigJpaProjectConnection();
                    DatabaseGroup.this.addJpaProjectConnectionListener();
                    DatabaseGroup.this.updateAddJpaProjectConnectionLink();
                    DatabaseGroup.this.connectionChanged();
                }

                public String toString() {
                    return "DatabaseSchemaWizardPage AddProjectConnection link selection listener";
                }
            };
        }

        void promptToConfigJpaProjectConnection() {
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)DatabaseSchemaWizardPage.this.getShell(), (IAdaptable)DatabaseSchemaWizardPage.this.jpaProject.getProject(), (String)"org.eclipse.jpt.jpa.ui.jpaProjectProperties", null, null);
            dialog.open();
        }

        private Label buildLabel(Composite parent, int span, String text) {
            Label label = new Label(parent, 0);
            label.setText(text);
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            label.setLayoutData((Object)gd);
            return label;
        }

        private Combo buildComboBox(Composite parent, SelectionListener listener) {
            Combo combo = new Combo(parent, 2056);
            combo.setLayoutData((Object)new GridData(768));
            combo.addSelectionListener(listener);
            return combo;
        }

        private Link buildLink(Composite parent, String text, SelectionListener listener) {
            Link link = new Link(parent, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            link.setLayoutData((Object)data);
            link.setText(text);
            link.addSelectionListener(listener);
            return link;
        }

        class LocalConnectionListener
        extends ConnectionAdapter {
            LocalConnectionListener() {
            }

            public void opened(ConnectionProfile cp) {
                this.connectionChanged();
            }

            public void closed(ConnectionProfile cp) {
                this.connectionChanged();
            }

            private void connectionChanged() {
                DisplayTools.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        DatabaseGroup.this.connectionChanged();
                    }
                });
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void selectedSchemaChanged(Schema var1);
    }
}

