/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.JoinStrategy;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AssociationAnnotationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JoinColumnsAnnotationEditor;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JoinPropertiesPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ManyToManyJoinPropsPage
extends JoinPropertiesPage {
    private Text mappedByText;
    private Button mappedByBrowseBtn;
    private Button joinTableRadio;
    private Text joinTableText;
    private Button joinTableBtn;
    private Button mappedByRadio;
    private Control joinColumnsCtl;
    private Control inverseJoinColumnsCtl;

    public ManyToManyJoinPropsPage(PersistenceUnit persistenceUnit, ResourceManager resourceManager, IProject project, String javaClass, Schema schema, Table table, Table inverseTable, EntityRefPropertyElem refElem) {
        super(persistenceUnit, resourceManager, project, javaClass, schema, table, inverseTable, refElem);
    }

    public Composite createJoinProps(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        group.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 400;
        gd.heightHint = 300;
        group.setLayoutData((Object)gd);
        this.mappedByRadio = AssociationAnnotationWizard.createButton(group, 1, JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_MAPPEDBY, -1, 16);
        this.mappedByText = AssociationAnnotationWizard.createText(group, true, 1, 2048);
        Image listImage = this.resourceManager.createImage(JptJpaUiImages.LIST_OF_VALUES);
        this.mappedByBrowseBtn = AssociationAnnotationWizard.createImageButton(group, listImage, 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        this.joinTableRadio = AssociationAnnotationWizard.createButton(group, 1, JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_JOIN_TABLE, -1, 16);
        this.joinTableText = AssociationAnnotationWizard.createText(group, true, 1, 2048);
        this.joinTableBtn = AssociationAnnotationWizard.createImageButton(group, listImage, 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        return group;
    }

    protected void initFields() {
        String mappedBy = this.refElem.getMappedBy();
        if (mappedBy != null) {
            this.mappedByRadio.setSelection(true);
            this.mappedByText.setEnabled(true);
            this.mappedByBrowseBtn.setEnabled(true);
            this.mappedByText.setText(mappedBy);
            this.joinTableRadio.setSelection(false);
            this.joinTableText.setEnabled(false);
            this.joinTableBtn.setEnabled(false);
        } else {
            this.mappedByRadio.setSelection(false);
            this.mappedByText.setEnabled(false);
            this.mappedByBrowseBtn.setEnabled(false);
            this.joinTableRadio.setSelection(true);
            this.joinTableText.setEnabled(true);
            this.joinTableBtn.setEnabled(true);
            if (this.refElem.getJoinTable() != null) {
                this.joinTableText.setText(this.refElem.getJoinTable().getTableName());
            }
        }
    }

    protected void addListeners() {
        super.addListeners();
        this.joinTableRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManyToManyJoinPropsPage.this.handleJoinPropsChange();
            }
        });
        this.joinTableText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ManyToManyJoinPropsPage.this.handleJoinTableChange(ManyToManyJoinPropsPage.this.joinTableText);
            }
        });
        this.joinTableBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManyToManyJoinPropsPage.this.chooseJoinTable(ManyToManyJoinPropsPage.this.joinTableText);
            }
        });
        this.mappedByText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ManyToManyJoinPropsPage.this.handleMappedByChange(ManyToManyJoinPropsPage.this.mappedByText);
            }
        });
        this.mappedByBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManyToManyJoinPropsPage.this.chooseMappedBy(ManyToManyJoinPropsPage.this.mappedByText);
            }
        });
        this.mappedByRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManyToManyJoinPropsPage.this.handleJoinPropsChange();
            }
        });
    }

    private void handleJoinPropsChange() {
        if (this.joinTableRadio.getSelection()) {
            this.refElem.setJoinStrategy(JoinStrategy.JOIN_TABLE);
            this.refElem.removeMappedBy();
            this.joinTableText.setEnabled(true);
            this.joinTableBtn.setEnabled(true);
            this.mappedByText.setText("");
            this.mappedByText.setEnabled(false);
            this.mappedByBrowseBtn.setEnabled(false);
        } else {
            this.refElem.setJoinStrategy(JoinStrategy.MAPPED_BY);
            this.refElem.removeJoinTable();
            this.joinTableText.setText("");
            this.joinTableText.setEnabled(false);
            this.joinTableBtn.setEnabled(false);
            this.mappedByText.setEnabled(true);
            this.mappedByBrowseBtn.setEnabled(true);
            this.refreshJoinProperties();
        }
    }

    protected void refreshJoinProperties() {
        if (this.joinColumnsCtl != null) {
            this.joinColumnsCtl.dispose();
        }
        if (this.inverseJoinColumnsCtl != null) {
            this.inverseJoinColumnsCtl.dispose();
        }
        String joinTableName = this.getJoinTableName();
        Table joinTable = null;
        if (joinTableName != null) {
            joinTable = this.schema.getTableNamed(joinTableName);
        }
        JoinColumnsAnnotationEditor joinColEditor = new JoinColumnsAnnotationEditor(this.resourceManager, this.refElem, false, joinTable, this.table, this);
        Composite joinProps = this.getJoinPropsComposite();
        this.joinColumnsCtl = joinColEditor.createJoinColumnsControl(joinProps);
        if (this.joinColumnsCtl != null) {
            GridData gd2 = new GridData(768);
            gd2.horizontalSpan = 3;
            gd2.widthHint = 400;
            this.joinColumnsCtl.setLayoutData((Object)gd2);
            joinProps.pack();
            joinProps.layout();
        }
        JoinColumnsAnnotationEditor inverseJoinColEditor = new JoinColumnsAnnotationEditor(this.resourceManager, this.refElem, true, joinTable, this.inverseTable, this);
        this.inverseJoinColumnsCtl = inverseJoinColEditor.createJoinColumnsControl(joinProps);
        if (this.inverseJoinColumnsCtl != null) {
            GridData gd2 = new GridData(768);
            gd2.horizontalSpan = 3;
            gd2.widthHint = 400;
            this.inverseJoinColumnsCtl.setLayoutData((Object)gd2);
            joinProps.pack();
            joinProps.layout();
        }
    }
}

