/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;

public class BP4106
extends AssertionProcess {
    private static final String CHUNKED_VALUE = "chunked";
    private final BaseMessageValidator validator;

    public BP4106(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String transferEncoding = (String)HTTPUtils.getHttpHeaderTokens(entryContext.getMessageEntry().getHTTPHeaders(), ":").get("Transfer-Encoding".toUpperCase());
        if (transferEncoding != null && !(transferEncoding = transferEncoding.toLowerCase()).equals(CHUNKED_VALUE)) {
            this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
        }
        if (this.failureDetail == null) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

