/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class AP2901
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private Collection mimeElements;

    public AP2901(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
        this.mimeElements = new HashSet();
        this.mimeElements.add(WSDL_MIME_CONTENT);
        this.mimeElements.add(WSDL_MIME_XML);
        this.mimeElements.add(WSDL_MIME_MULTIPART);
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            int i = 0;
            while (i < ops.size()) {
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                QName inapplicableElement = null;
                if (bindingInput != null && (inapplicableElement = this.getInapplicableElement(bindingInput.getExtensibilityElements())) != null) {
                    throw new AssertionFailException(inapplicableElement.toString());
                }
                if (bindingOutput != null && (inapplicableElement = this.getInapplicableElement(bindingOutput.getExtensibilityElements())) != null) {
                    throw new AssertionFailException(inapplicableElement.toString());
                }
                ++i;
            }
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private QName getInapplicableElement(List extElems) {
        int i = 0;
        while (i < extElems.size()) {
            QName elementName = ((ExtensibilityElement)extElems.get(i)).getElementType();
            if (!(this.mimeElements.contains(elementName) || elementName.equals(WSDL_SOAP_BODY) || elementName.equals(WSDL_SOAP_HEADER))) {
                return elementName;
            }
            ++i;
        }
        return null;
    }
}

