/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.webfragment.WebFragmentUtil;
import org.eclipse.m2e.wtp.overlay.modulecore.IOverlayVirtualComponent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRoot;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WTPProjectsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WTPProjectsUtil.class);
    public static final IProjectFacet UTILITY_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
    public static final IProjectFacetVersion UTILITY_10 = UTILITY_FACET.getVersion("1.0");
    public static final IProjectFacet EJB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
    public static final IProjectFacet JCA_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.connector");
    public static final IProjectFacet WEB_FRAGMENT_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.webfragment");
    public static final IProjectFacetVersion WEB_FRAGMENT_3_0 = WEB_FRAGMENT_FACET.getVersion("3.0");
    public static final IProjectFacet DYNAMIC_WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    public static final IProjectFacet APP_CLIENT_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
    public static final IClasspathAttribute NONDEPENDENCY_ATTRIBUTE = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.nondependency", (String)"");
    public static final IProjectFacetVersion DEFAULT_WEB_FACET = DYNAMIC_WEB_FACET.getVersion("2.5");
    public static final IProjectFacet EAR_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
    public static final String DYN_REQUESTED_REFERENCE_TYPE;
    public static final String M2E_WTP_ACTIVATION_PROPERTY = "m2e.wtp.activation";

    static {
        String reqRefType = null;
        try {
            Field displayableRefsAllField = IVirtualComponent.class.getField("DISPLAYABLE_REFERENCES_ALL");
            reqRefType = (String)displayableRefsAllField.get(null);
        }
        catch (Throwable throwable) {
            reqRefType = "HARD_REFERENCES";
        }
        DYN_REQUESTED_REFERENCE_TYPE = reqRefType;
    }

    public static boolean hasInClassPath(IProject project, String className) {
        boolean result = false;
        if (project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                if (javaProject != null && javaProject.findType(className) != null) {
                    result = true;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return result;
    }

    public static boolean isJavaEEProject(IProject project) {
        return (J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project) || J2EEProjectUtilities.isJEEProject((IProject)project)) && !JavaEEProjectUtilities.isUtilityProject((IProject)project);
    }

    public static void deleteLinks(IProject project, IPath runtimePath, IProgressMonitor monitor) throws CoreException {
        WTPProjectsUtil.deleteLinks(project, runtimePath, null, monitor);
    }

    public static void deleteLinks(IProject project, IPath runtimePath, List<IPath> sourcePathToKeep, IProgressMonitor monitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            ComponentResource[] resources;
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)project);
            if (moduleCore == null) {
                return;
            }
            WorkbenchComponent component = moduleCore.getComponent();
            if (component == null) {
                return;
            }
            ResourceTreeRoot root = ResourceTreeRoot.getDeployResourceTreeRoot((WorkbenchComponent)component);
            ComponentResource[] componentResourceArray = resources = root.findModuleResources(runtimePath, 0);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentResource link = componentResourceArray[n2];
                if (runtimePath.equals((Object)link.getRuntimePath()) && (sourcePathToKeep == null || !sourcePathToKeep.contains(link.getSourcePath()))) {
                    component.getResources().remove((Object)link);
                }
                ++n2;
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(monitor);
                moduleCore.dispose();
            }
        }
    }

    public static void insertLinkBefore(IProject project, IPath newSource, IPath referenceSource, IPath runtimePath, IProgressMonitor monitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)project);
            if (moduleCore == null) {
                return;
            }
            WorkbenchComponent component = moduleCore.getComponent();
            if (component == null) {
                return;
            }
            int i = 0;
            int refPosition = -1;
            int newSourcePosition = -1;
            EList resources = component.getResources();
            for (ComponentResource resource : resources) {
                IPath sourcePath = resource.getSourcePath();
                if (referenceSource.equals((Object)sourcePath)) {
                    refPosition = i;
                } else if (newSource.equals((Object)sourcePath)) {
                    newSourcePosition = i;
                }
                if (refPosition > -1 && newSourcePosition > -1) break;
                ++i;
            }
            if (refPosition < 0) {
                refPosition = i;
            }
            IFolder folder = project.getFolder(newSource);
            if (newSourcePosition > refPosition) {
                component.getResources().move(newSourcePosition, refPosition);
            } else if (newSourcePosition < 0) {
                ComponentResource componentResource = moduleCore.createWorkbenchModuleResource((IResource)folder);
                componentResource.setRuntimePath(runtimePath);
                component.getResources().add(refPosition, (Object)componentResource);
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(monitor);
                moduleCore.dispose();
            }
        }
    }

    public static void insertLinkFirst(IProject project, IPath newSource, IPath runtimePath, IProgressMonitor monitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)project);
            if (moduleCore == null) {
                return;
            }
            WorkbenchComponent component = moduleCore.getComponent();
            if (component == null) {
                return;
            }
            IFolder folder = project.getFolder(newSource);
            ComponentResource componentResource = moduleCore.createWorkbenchModuleResource((IResource)folder);
            componentResource.setRuntimePath(runtimePath);
            component.getResources().add(0, (Object)componentResource);
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(monitor);
                moduleCore.dispose();
            }
        }
    }

    public static boolean hasLink(IProject project, IPath runtimePath, IPath aProjectRelativeLocation, IProgressMonitor monitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            ResourceTreeRoot root;
            ComponentResource[] resources;
            WorkbenchComponent component;
            moduleCore = StructureEdit.getStructureEditForRead((IProject)project);
            if (moduleCore != null && (component = moduleCore.getComponent()) != null && (resources = (root = ResourceTreeRoot.getDeployResourceTreeRoot((WorkbenchComponent)component)).findModuleResources(runtimePath, 0)).length > 0) {
                int resourceIndx = 0;
                if (resourceIndx < resources.length) {
                }
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
            }
        }
        return false;
    }

    public static IPath tryProjectRelativePath(IProject project, String resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        IPath projectLocation = project.getLocation();
        IPath directory = Path.fromOSString((String)resourceLocation);
        if (projectLocation == null || !projectLocation.isPrefixOf(directory)) {
            return directory;
        }
        return directory.removeFirstSegments(projectLocation.segmentCount()).makeRelative().setDevice(null);
    }

    public static boolean hasChanged(IVirtualReference[] existingRefs, IVirtualReference[] refArray) {
        if (existingRefs == refArray) {
            return false;
        }
        if (existingRefs == null || existingRefs.length != refArray.length) {
            return true;
        }
        int i = 0;
        while (i < existingRefs.length) {
            IVirtualReference existingRef = existingRefs[i];
            IVirtualReference newRef = refArray[i];
            if (existingRef.getArchiveName() != null && !existingRef.getArchiveName().equals(newRef.getArchiveName()) || existingRef.getArchiveName() == null && newRef.getArchiveName() != null || !existingRef.getReferencedComponent().equals(newRef.getReferencedComponent()) || !existingRef.getRuntimePath().equals((Object)newRef.getRuntimePath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasChanged2(IVirtualReference[] existingRefs, IVirtualReference[] refArray) {
        if (existingRefs == refArray) {
            return false;
        }
        if (existingRefs == null || existingRefs.length != refArray.length) {
            return true;
        }
        int i = 0;
        while (i < existingRefs.length) {
            IVirtualReference existingRef = existingRefs[i];
            IVirtualReference newRef = refArray[i];
            if (!existingRef.getReferencedComponent().equals(newRef.getReferencedComponent()) || !existingRef.getRuntimePath().equals((Object)newRef.getRuntimePath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IVirtualReference[] extractHardReferences(IVirtualComponent warComponent, boolean overlays) {
        HashMap<String, String> options = new HashMap<String, String>(1);
        options.put("REQUESTED_REFERENCE_TYPE", DYN_REQUESTED_REFERENCE_TYPE);
        IVirtualReference[] allReferences = warComponent.getReferences(options);
        if (allReferences == null || allReferences.length == 0) {
            return new IVirtualReference[0];
        }
        ArrayList<IVirtualReference> selectedRefs = new ArrayList<IVirtualReference>();
        IVirtualReference[] iVirtualReferenceArray = allReferences;
        int n = allReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent component = ref.getReferencedComponent();
            if (component != null) {
                if (component instanceof IOverlayVirtualComponent) {
                    if (overlays) {
                        selectedRefs.add(ref);
                    }
                } else if (!overlays) {
                    selectedRefs.add(ref);
                }
            }
            ++n2;
        }
        IVirtualReference[] selectedReferences = new IVirtualReference[selectedRefs.size()];
        selectedRefs.toArray(selectedReferences);
        return selectedReferences;
    }

    public static void removeWTPClasspathContainer(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                String path = entry.getPath().toString();
                if (!"org.eclipse.jst.j2ee.internal.module.container".equals(path) && !"org.eclipse.jst.j2ee.internal.web.container".equals(path)) {
                    newEntries.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
    }

    public static void removeConflictingFacets(IFacetedProject project, IProjectFacetVersion facetVersion, Set<IFacetedProject.Action> actions) {
        if (project == null) {
            throw new IllegalArgumentException(Messages.WTPProjectsUtil_Project_Cant_Be_Null);
        }
        if (facetVersion == null) {
            throw new IllegalArgumentException(Messages.WTPProjectsUtil_Facet_Version_Cant_Be_Null);
        }
        if (actions == null) {
            throw new IllegalArgumentException(Messages.WTPProjectsUtil_Actions_Cant_Be_Null);
        }
        for (IProjectFacetVersion existingFacetVersion : project.getProjectFacets()) {
            if (!facetVersion.conflictsWith(existingFacetVersion)) continue;
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, existingFacetVersion, null));
        }
    }

    public static void installJavaFacet(Set<IFacetedProject.Action> actions, IProject project, IFacetedProject facetedProject) {
        IProjectFacetVersion javaFv = JavaFacet.FACET.getVersion(JavaFacetUtil.getCompilerLevel((IProject)project));
        if (!facetedProject.hasProjectFacet(JavaFacet.FACET)) {
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javaFv, null));
        } else if (!facetedProject.hasProjectFacet(javaFv)) {
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, javaFv, null));
        }
    }

    public static boolean hasWebFragmentFacet(IProject project) {
        return FacetedProjectUtilities.isProjectOfType((IProject)project, (String)WEB_FRAGMENT_FACET.getId());
    }

    public static boolean isQualifiedAsWebFragment(IMavenProjectFacade facade) {
        return WebFragmentUtil.isQualifiedAsWebFragment(facade);
    }

    public static IFolder getClassesFolder(IMavenProjectFacade facade) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder output = root.getFolder(facade.getOutputLocation());
        return output;
    }

    public static void removeTestFolderLinks(IProject project, MavenProject mavenProject, IProgressMonitor monitor, String folder) throws CoreException {
        IPath location;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return;
        }
        IVirtualFolder jsrc = component.getRootFolder().getFolder(folder);
        IPath[] iPathArray = MavenProjectUtils.getSourceLocations((IProject)project, (List)mavenProject.getTestCompileSourceRoots());
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            location = iPathArray[n2];
            if (location != null) {
                jsrc.removeLink(location, 0, monitor);
            }
            ++n2;
        }
        iPathArray = MavenProjectUtils.getResourceLocations((IProject)project, (List)mavenProject.getTestResources());
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            location = iPathArray[n2];
            if (location != null) {
                jsrc.removeLink(location, 0, monitor);
            }
            ++n2;
        }
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null) {
                return;
            }
            IPath testOutputDirPath = MavenProjectUtils.getProjectRelativePath((IProject)project, (String)mavenProject.getBuild().getTestOutputDirectory());
            if (testOutputDirPath == null) {
                return;
            }
            IPath testPath = project.getFullPath().append(testOutputDirPath);
            IClasspathEntry[] cpes = javaProject.getRawClasspath();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IClasspathEntry[] iClasspathEntryArray = cpes;
            int n3 = cpes.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath sourcePath;
                IPath outputLocation;
                IClasspathEntry cpe = iClasspathEntryArray[n4];
                if (cpe != null && cpe.getEntryKind() == 3 && testPath.equals((Object)(outputLocation = cpe.getOutputLocation())) && (sourcePath = root.getFolder(cpe.getPath()).getProjectRelativePath()) != null) {
                    jsrc.removeLink(sourcePath, 0, monitor);
                }
                ++n4;
            }
        }
    }

    public static void setNonDependencyAttributeToContainer(IProject project, IProgressMonitor monitor) throws JavaModelException {
        WTPProjectsUtil.updateContainerAttributes(project, NONDEPENDENCY_ATTRIBUTE, "org.eclipse.jst.component.dependency", monitor);
    }

    public static void updateContainerAttributes(IProject project, IClasspathAttribute attributeToAdd, String attributeToDelete, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return;
        }
        IClasspathEntry[] cp = javaProject.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            if (5 == cp[i].getEntryKind() && MavenClasspathHelpers.isMaven2ClasspathContainer((IPath)cp[i].getPath())) {
                LinkedHashMap<String, IClasspathAttribute> attrs = new LinkedHashMap<String, IClasspathAttribute>();
                IClasspathAttribute[] iClasspathAttributeArray = cp[i].getExtraAttributes();
                int n = iClasspathAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathAttribute attr = iClasspathAttributeArray[n2];
                    if (!attr.getName().equals(attributeToDelete)) {
                        attrs.put(attr.getName(), attr);
                    }
                    ++n2;
                }
                attrs.put(attributeToAdd.getName(), attributeToAdd);
                IClasspathAttribute[] newAttrs = attrs.values().toArray(new IClasspathAttribute[attrs.size()]);
                cp[i] = JavaCore.newContainerEntry((IPath)cp[i].getPath(), (IAccessRule[])cp[i].getAccessRules(), (IClasspathAttribute[])newAttrs, (boolean)cp[i].isExported());
                break;
            }
            ++i;
        }
        javaProject.setRawClasspath(cp, monitor);
    }

    public static void fixMissingModuleCoreNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (ModuleCoreNature.addModuleCoreNatureIfNecessary((IProject)project, (IProgressMonitor)monitor) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", NLS.bind((String)Messages.WTPProjectsUtil_Unable_To_Add_ModuleCoreNature, (Object)project.getName()), null));
        }
    }

    public static boolean isJavaProject(IMavenProjectFacade facade) {
        if (facade == null || facade.getMavenProject() == null || facade.getMavenProject().getArtifact() == null || facade.getMavenProject().getArtifact().getArtifactHandler() == null) {
            return false;
        }
        String language = facade.getMavenProject().getArtifact().getArtifactHandler().getLanguage();
        return "java".equals(language);
    }

    public static void setDefaultDeploymentDescriptorFolder(IVirtualFolder folder, IPath aProjectRelativeLocation, IProgressMonitor monitor) {
        IPath currentDefaultLocation = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder((IVirtualFolder)folder);
        if (aProjectRelativeLocation.equals((Object)currentDefaultLocation)) {
            return;
        }
        J2EEModuleVirtualComponent.setDefaultDeploymentDescriptorFolder((IVirtualFolder)folder, (IPath)aProjectRelativeLocation, (IProgressMonitor)monitor);
    }

    public static IFolder getDefaultDeploymentDescriptorFolder(IVirtualFolder vFolder) {
        IPath defaultPath = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder((IVirtualFolder)vFolder);
        IFolder folder = null;
        IVirtualComponent component = vFolder.getComponent();
        if (defaultPath == null) {
            IContainer container = vFolder.getUnderlyingFolder();
            if (container instanceof IFolder) {
                folder = (IFolder)container;
            }
        } else if (!defaultPath.isRoot()) {
            folder = component.getProject().getFolder(defaultPath);
        }
        return folder;
    }

    public static boolean isWTPProject(IProject project) {
        return ModuleCoreNature.getModuleCoreNature((IProject)project) != null;
    }

    public static boolean isM2eWtpDisabled(IMavenProjectFacade facade, IProgressMonitor monitor) {
        if (facade == null) {
            return true;
        }
        Object pomActivationValue = null;
        try {
            MavenProject mavenProject = facade.getMavenProject(monitor);
            pomActivationValue = mavenProject == null ? null : mavenProject.getProperties().get(M2E_WTP_ACTIVATION_PROPERTY);
        }
        catch (CoreException ex) {
            LOG.error("Unable to load Maven project", (Throwable)ex);
        }
        boolean enabled = pomActivationValue == null ? MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().getPreferences(facade.getProject()).isEnabled() : Boolean.parseBoolean(pomActivationValue.toString());
        return !enabled;
    }

    public static boolean isLastConfigurator(IMavenProjectFacade facade, Class<? extends AbstractProjectConfigurator> clazz, String id) {
        String lastConfigurator = null;
        Map configurators = LifecycleMappingFactory.getProjectConfigurators((IMavenProjectFacade)facade);
        for (Map.Entry e : configurators.entrySet()) {
            if (!((AbstractProjectConfigurator)e.getValue()).getClass().equals(clazz)) continue;
            lastConfigurator = (String)e.getKey();
        }
        return id.equals(lastConfigurator);
    }
}

