/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script.prop;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.EncogError;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.script.prop.PropertyEntry;
import org.encog.app.analyst.script.prop.PropertyType;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.file.ResourceInputStream;

public final class PropertyConstraints {
    private static PropertyConstraints instance;
    private final Map<String, List<PropertyEntry>> data = new HashMap<String, List<PropertyEntry>>();

    public static PropertyConstraints getInstance() {
        if (instance == null) {
            instance = new PropertyConstraints();
        }
        return instance;
    }

    private PropertyConstraints() {
        try {
            InputStream is = ResourceInputStream.openResourceInputStream("org/encog/data/analyst.csv");
            ReadCSV csv = new ReadCSV(is, false, CSVFormat.EG_FORMAT);
            while (csv.next()) {
                List<Object> list;
                String sectionStr = csv.get(0);
                String nameStr = csv.get(1);
                String typeStr = csv.get(2);
                PropertyType t = null;
                if ("boolean".equalsIgnoreCase(typeStr)) {
                    t = PropertyType.TypeBoolean;
                } else if ("real".equalsIgnoreCase(typeStr)) {
                    t = PropertyType.TypeDouble;
                } else if ("format".equalsIgnoreCase(typeStr)) {
                    t = PropertyType.typeFormat;
                } else if ("int".equalsIgnoreCase(typeStr)) {
                    t = PropertyType.TypeInteger;
                } else if ("list-string".equalsIgnoreCase(typeStr)) {
                    t = PropertyType.TypeListString;
                } else if ("string".equalsIgnoreCase(typeStr)) {
                    t = PropertyType.TypeString;
                } else {
                    throw new AnalystError("Unknown type constraint: " + typeStr);
                }
                PropertyEntry entry = new PropertyEntry(t, nameStr, sectionStr);
                if (this.data.containsKey(sectionStr)) {
                    list = this.data.get(sectionStr);
                } else {
                    list = new ArrayList();
                    this.data.put(sectionStr, list);
                }
                list.add(entry);
            }
            csv.close();
            is.close();
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
    }

    public PropertyEntry findEntry(String v) {
        String[] cols = v.split("\\.");
        String section = cols[0];
        String subSection = cols[1];
        String name = cols[2];
        return this.getEntry(section, subSection, name);
    }

    public List<PropertyEntry> getEntries(String section, String subSection) {
        String key = section + ":" + subSection;
        return this.data.get(key);
    }

    public PropertyEntry getEntry(String section, String subSection, String name) {
        String key = section.toUpperCase() + ":" + subSection.toUpperCase();
        List<PropertyEntry> list = this.data.get(key);
        if (list == null) {
            throw new AnalystError("Unknown section and subsection: " + section + "." + subSection);
        }
        for (PropertyEntry entry : list) {
            if (!entry.getName().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return null;
    }
}

