/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.quant.indicators;

import java.util.Map;
import org.encog.app.analyst.csv.basic.BaseCachedColumn;
import org.encog.app.quant.indicators.Indicator;

public class MovingAverage
extends Indicator {
    public static final String NAME = "MovAvg";
    private final int periods;

    public MovingAverage(int thePeriods, boolean output) {
        super(NAME, false, output);
        this.periods = thePeriods;
        this.setOutput(output);
    }

    @Override
    public final void calculate(Map<String, BaseCachedColumn> data, int length) {
        int trailingIdx;
        int lookbackTotal;
        this.require(data, "close");
        double[] close = data.get("close").getData();
        double[] output = this.getData();
        int start = lookbackTotal = this.periods - 1;
        if (start > this.periods - 1) {
            return;
        }
        double periodTotal = 0.0;
        int i = trailingIdx = start - lookbackTotal;
        if (this.periods > 1) {
            while (i < start) {
                periodTotal += close[i++];
            }
        }
        int outIdx = this.periods - 1;
        do {
            double t = periodTotal += close[i++];
            periodTotal -= close[trailingIdx++];
            output[outIdx++] = t / (double)this.periods;
        } while (i < close.length);
        this.setBeginningIndex(this.periods - 1);
        this.setEndingIndex(output.length - 1);
        for (i = 0; i < this.periods - 1; ++i) {
            output[i] = 0.0;
        }
    }

    @Override
    public final int getPeriods() {
        return this.periods;
    }
}

