/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.quant.indicators.predictive;

import java.util.Map;
import org.encog.app.analyst.csv.basic.BaseCachedColumn;
import org.encog.app.quant.indicators.Indicator;

public class BestClose
extends Indicator {
    public static final String NAME = "PredictBestClose";
    private final int periods;

    public BestClose(int thePeriods, boolean output) {
        super(NAME, false, output);
        this.periods = thePeriods;
        this.setOutput(output);
    }

    @Override
    public final void calculate(Map<String, BaseCachedColumn> data, int length) {
        int i;
        double[] close = data.get("close").getData();
        double[] output = this.getData();
        int stop = length - this.periods;
        for (i = 0; i < stop; ++i) {
            double bestClose = Double.MIN_VALUE;
            for (int j = 1; j <= this.periods; ++j) {
                bestClose = Math.max(close[i + j], bestClose);
            }
            output[i] = bestClose;
        }
        for (i = length - this.periods; i < length; ++i) {
            output[i] = 0.0;
        }
        this.setBeginningIndex(0);
        this.setEndingIndex(length - this.periods - 1);
    }

    @Override
    public final int getPeriods() {
        return this.periods;
    }
}

