/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.persist.PersistError;
import org.encog.util.csv.CSVFormat;

public class PersistBasicNetwork
implements EncogPersistor {
    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getPersistClassString() {
        return "BasicNetwork";
    }

    @Override
    public Object read(InputStream is) {
        EncogFileSection section;
        BasicNetwork result = new BasicNetwork();
        FlatNetwork flat = new FlatNetwork();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("BASIC") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (section.getSectionName().equals("BASIC") && section.getSubSectionName().equals("NETWORK")) {
                params = section.parseParams();
                flat.setBeginTraining(EncogFileSection.parseInt(params, "beginTraining"));
                flat.setConnectionLimit(EncogFileSection.parseDouble(params, "connectionLimit"));
                flat.setContextTargetOffset(EncogFileSection.parseIntArray(params, "contextTargetOffset"));
                flat.setContextTargetSize(EncogFileSection.parseIntArray(params, "contextTargetSize"));
                flat.setEndTraining(EncogFileSection.parseInt(params, "endTraining"));
                flat.setHasContext(EncogFileSection.parseBoolean(params, "hasContext"));
                flat.setInputCount(EncogFileSection.parseInt(params, "inputCount"));
                flat.setLayerCounts(EncogFileSection.parseIntArray(params, "layerCounts"));
                flat.setLayerFeedCounts(EncogFileSection.parseIntArray(params, "layerFeedCounts"));
                flat.setLayerContextCount(EncogFileSection.parseIntArray(params, "layerContextCount"));
                flat.setLayerIndex(EncogFileSection.parseIntArray(params, "layerIndex"));
                flat.setLayerOutput(section.parseDoubleArray(params, "output"));
                flat.setLayerSums(new double[flat.getLayerOutput().length]);
                flat.setOutputCount(EncogFileSection.parseInt(params, "outputCount"));
                flat.setWeightIndex(EncogFileSection.parseIntArray(params, "weightIndex"));
                flat.setWeights(section.parseDoubleArray(params, "weights"));
                flat.setBiasActivation(section.parseDoubleArray(params, "biasActivation"));
                continue;
            }
            if (!section.getSectionName().equals("BASIC") || !section.getSubSectionName().equals("ACTIVATION")) continue;
            int index = 0;
            flat.setActivationFunctions(new ActivationFunction[flat.getLayerCounts().length]);
            for (String line : section.getLines()) {
                ActivationFunction af = null;
                List<String> cols = EncogFileSection.splitColumns(line);
                String name = cols.get(0).indexOf(46) != -1 ? cols.get(0) : "org.encog.engine.network.activation." + cols.get(0);
                try {
                    Class<?> clazz = Class.forName(name);
                    af = (ActivationFunction)clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new PersistError(e);
                }
                catch (InstantiationException e) {
                    throw new PersistError(e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistError(e);
                }
                for (int i = 0; i < af.getParamNames().length; ++i) {
                    af.setParam(i, CSVFormat.EG_FORMAT.parse(cols.get(i + 1)));
                }
                flat.getActivationFunctions()[index++] = af;
            }
        }
        result.getStructure().setFlat(flat);
        result.updateProperties();
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        BasicNetwork net = (BasicNetwork)obj;
        FlatNetwork flat = net.getStructure().getFlat();
        out.addSection("BASIC");
        out.addSubSection("PARAMS");
        out.addProperties(net.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("beginTraining", flat.getBeginTraining());
        out.writeProperty("connectionLimit", flat.getConnectionLimit());
        out.writeProperty("contextTargetOffset", flat.getContextTargetOffset());
        out.writeProperty("contextTargetSize", flat.getContextTargetSize());
        out.writeProperty("endTraining", flat.getEndTraining());
        out.writeProperty("hasContext", flat.getHasContext());
        out.writeProperty("inputCount", flat.getInputCount());
        out.writeProperty("layerCounts", flat.getLayerCounts());
        out.writeProperty("layerFeedCounts", flat.getLayerFeedCounts());
        out.writeProperty("layerContextCount", flat.getLayerContextCount());
        out.writeProperty("layerIndex", flat.getLayerIndex());
        out.writeProperty("output", flat.getLayerOutput());
        out.writeProperty("outputCount", flat.getOutputCount());
        out.writeProperty("weightIndex", flat.getWeightIndex());
        out.writeProperty("weights", flat.getWeights());
        out.writeProperty("biasActivation", flat.getBiasActivation());
        out.addSubSection("ACTIVATION");
        for (ActivationFunction af : flat.getActivationFunctions()) {
            String sn = af.getClass().getSimpleName();
            if (sn.startsWith("org.encog.")) {
                out.addColumn(sn);
            } else {
                out.addColumn(af.getClass().getName());
            }
            for (int i = 0; i < af.getParams().length; ++i) {
                out.addColumn(af.getParams()[i]);
            }
            out.writeLine();
        }
        out.flush();
    }
}

