/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.strategy;

import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.neural.networks.training.Momentum;
import org.encog.util.logging.EncogLogging;

public class SmartMomentum
implements Strategy {
    public static final double MIN_IMPROVEMENT = 1.0E-4;
    public static final double MAX_MOMENTUM = 4.0;
    public static final double START_MOMENTUM = 0.1;
    public static final double MOMENTUM_INCREASE = 0.01;
    public static final double MOMENTUM_CYCLES = 10.0;
    private MLTrain train;
    private Momentum setter;
    private double lastImprovement;
    private double lastError;
    private boolean ready;
    private int lastMomentum;
    private double currentMomentum;

    @Override
    public void init(MLTrain train) {
        this.train = train;
        this.setter = (Momentum)((Object)train);
        this.ready = false;
        this.setter.setMomentum(0.0);
        this.currentMomentum = 0.0;
    }

    @Override
    public void postIteration() {
        if (this.ready) {
            double currentError = this.train.getError();
            this.lastImprovement = (currentError - this.lastError) / this.lastError;
            EncogLogging.log(0, "Last improvement: " + this.lastImprovement);
            if (this.lastImprovement > 0.0 || Math.abs(this.lastImprovement) < 1.0E-4) {
                ++this.lastMomentum;
                if ((double)this.lastMomentum > 10.0) {
                    this.lastMomentum = 0;
                    if ((int)this.currentMomentum == 0) {
                        this.currentMomentum = 0.1;
                    }
                    this.currentMomentum *= 1.01;
                    this.setter.setMomentum(this.currentMomentum);
                    EncogLogging.log(0, "Adjusting momentum: " + this.currentMomentum);
                }
            } else {
                EncogLogging.log(0, "Setting momentum back to zero.");
                this.currentMomentum = 0.0;
                this.setter.setMomentum(0.0);
            }
        } else {
            this.ready = true;
        }
    }

    @Override
    public void preIteration() {
        this.lastError = this.train.getError();
    }
}

